/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.models;

import com.conquestreforged.content.blocks.block.BoardsHorizontal;
import com.conquestreforged.content.blocks.block.Layer;
import com.conquestreforged.content.blocks.block.Slab;
import com.conquestreforged.content.blocks.block.SlabLessLayers;
import com.conquestreforged.content.blocks.block.VerticalSlab;
import com.conquestreforged.content.blocks.block.directional.SlabDirectionalWaterlogged;
import com.conquestreforged.content.blocks.block.plants.LichenMoss;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class XYZBakedModel
extends ForwardingBakedModel {
    public XYZBakedModel(BakedModel baseModel) {
        this.wrapped = baseModel;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, RenderContext context) {
        BlockState blockStateDown = blockView.m_8055_(pos.m_7495_());
        Block blockDown = blockStateDown.m_60734_();
        float translationAmountXZ = 0.0f;
        boolean translatableXZ = false;
        float translationAmountY = 0.0f;
        boolean translatableY = false;
        Direction directionXZ = null;
        if (state.m_60734_() instanceof LichenMoss) {
            Direction connectedDir = this.getLichenMossConnectionDirection(state);
            directionXZ = connectedDir.m_122424_();
            BlockState offsetBlock = blockView.m_8055_(pos.m_5484_(connectedDir, 1));
            if (offsetBlock.m_60734_() instanceof VerticalSlab && offsetBlock.m_61143_((Property)BlockStateProperties.f_61374_) == directionXZ) {
                translationAmountXZ = this.computeVerticalSlabTranslation(offsetBlock);
                boolean bl = translatableXZ = translationAmountXZ != 0.0f;
            }
            if (((Boolean)state.m_61143_((Property)PipeBlock.f_55153_)).booleanValue()) {
                translationAmountY = this.computeYTranslation(blockStateDown);
                translatableY = translationAmountY != 0.0f;
            }
            this.pushTransform(context, translatableY, translatableXZ, translationAmountY, translationAmountXZ, directionXZ);
            context.pushTransform(quad -> true);
        } else {
            Direction direction;
            BlockState offsetBlock;
            if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                Direction direction2 = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                BlockState offsetBlock2 = blockView.m_8055_(pos.m_5484_(direction2.m_122424_(), 1));
                if (offsetBlock2.m_60734_() instanceof VerticalSlab && direction2 == offsetBlock2.m_61143_((Property)BlockStateProperties.f_61374_)) {
                    translationAmountXZ = this.computeVerticalSlabTranslation(offsetBlock2);
                    directionXZ = direction2;
                    translatableXZ = translationAmountXZ != 0.0f;
                }
            } else if (state.m_61138_((Property)BlockStateProperties.f_61372_) && ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_().m_122479_() && (offsetBlock = blockView.m_8055_(pos.m_5484_((direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_(), 1))).m_60734_() instanceof VerticalSlab && direction == offsetBlock.m_61143_((Property)BlockStateProperties.f_61374_)) {
                translationAmountXZ = this.computeVerticalSlabTranslation(offsetBlock);
                directionXZ = direction;
                boolean bl = translatableXZ = translationAmountXZ != 0.0f;
            }
            if (blockDown instanceof SlabBlock && blockStateDown.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.BOTTOM) {
                translationAmountY = -0.5f;
                translatableY = true;
            } else {
                translationAmountY = this.computeYTranslation(blockStateDown);
                translatableY = translationAmountY != 0.0f;
            }
            this.pushTransform(context, translatableY, translatableXZ, translationAmountY, translationAmountXZ, directionXZ);
        }
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
    }

    private void pushTransform(RenderContext context, boolean translatableY, boolean translatableXZ, float translationAmountY, float translationAmountXZ, Direction directionXZ) {
        if (translatableY || translatableXZ) {
            context.pushTransform(quad -> {
                if (translatableY) {
                    this.translateDown(quad, translationAmountY);
                }
                if (translatableXZ) {
                    this.translateXZ(quad, translationAmountXZ, directionXZ);
                }
                return true;
            });
        } else {
            context.pushTransform(quad -> true);
        }
    }

    private float computeYTranslation(BlockState downState) {
        Block block = downState.m_60734_();
        if (block instanceof SlabBlock && downState.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.BOTTOM) {
            return -0.5f;
        }
        if (block instanceof Layer || block instanceof SnowLayerBlock) {
            int layers = (Integer)downState.m_61143_((Property)BlockStateProperties.f_61417_);
            return switch (layers) {
                case 7 -> -0.125f;
                case 6 -> -0.25f;
                case 5 -> -0.375f;
                case 4 -> -0.5f;
                case 3 -> -0.625f;
                case 2 -> -0.75f;
                case 1 -> -0.875f;
                default -> 0.0f;
            };
        }
        if (block instanceof Slab && downState.m_61143_(Slab.TYPE_UPDOWN) == Half.BOTTOM) {
            int layers = (Integer)downState.m_61143_((Property)Slab.LAYERS);
            return switch (layers) {
                case 7 -> -0.125f;
                case 6 -> -0.25f;
                case 5 -> -0.375f;
                case 4 -> -0.5f;
                case 3 -> -0.625f;
                case 2 -> -0.75f;
                case 1 -> -0.875f;
                default -> 0.0f;
            };
        }
        if (block instanceof SlabLessLayers && downState.m_61143_(SlabLessLayers.TYPE_UPDOWN) == Half.BOTTOM) {
            int layers = (Integer)downState.m_61143_((Property)SlabLessLayers.LAYERS);
            return switch (layers) {
                case 4 -> -0.25f;
                case 3 -> -0.5f;
                case 2 -> -0.75f;
                case 1 -> -0.875f;
                default -> 0.0f;
            };
        }
        if (block instanceof BoardsHorizontal && downState.m_61143_(SlabDirectionalWaterlogged.TYPE_UPDOWN) == Half.BOTTOM) {
            return -0.53125f;
        }
        return 0.0f;
    }

    private float computeVerticalSlabTranslation(BlockState offsetBlock) {
        int layers = (Integer)offsetBlock.m_61143_((Property)VerticalSlab.LAYERS);
        return switch (layers) {
            case 1 -> -0.875f;
            case 2 -> -0.75f;
            case 3 -> -0.5f;
            case 4 -> -0.25f;
            default -> 0.0f;
        };
    }

    private Direction getLichenMossConnectionDirection(BlockState state) {
        if (((Boolean)state.m_61143_((Property)PipeBlock.f_55148_)).booleanValue()) {
            return Direction.NORTH;
        }
        if (((Boolean)state.m_61143_((Property)PipeBlock.f_55149_)).booleanValue()) {
            return Direction.EAST;
        }
        if (((Boolean)state.m_61143_((Property)PipeBlock.f_55150_)).booleanValue()) {
            return Direction.SOUTH;
        }
        if (((Boolean)state.m_61143_((Property)PipeBlock.f_55151_)).booleanValue()) {
            return Direction.WEST;
        }
        return Direction.NORTH;
    }

    public void translateDown(MutableQuadView quad, float translationAmount) {
        this.translate(quad, 0.0f, translationAmount, 0.0f);
    }

    public void translateXZ(MutableQuadView quad, float translationAmount, Direction direction) {
        float dx = 0.0f;
        float dz = 0.0f;
        switch (direction) {
            case NORTH: {
                dz = -translationAmount;
                break;
            }
            case EAST: {
                dx = translationAmount;
                break;
            }
            case SOUTH: {
                dz = translationAmount;
                break;
            }
            case WEST: {
                dx = -translationAmount;
                break;
            }
        }
        this.translate(quad, dx, 0.0f, dz);
    }

    private void translate(MutableQuadView quad, float dx, float dy, float dz) {
        for (int i = 0; i < 4; ++i) {
            quad.pos(i, quad.x(i) + dx, quad.y(i) + dy, quad.z(i) + dz);
        }
    }
}

