/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.gui.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;

public class ModelRender {
    private static final int[] lightmap = new int[]{0xF000F0, 0xF000F0, 0xF000F0, 0xF000F0};
    private static final Matrix4f flipX = new Matrix4f().scale(-1.0f, 1.0f, 1.0f);
    private static final Matrix3f flipXNormal = new Matrix3f((Matrix4fc)flipX);

    public static void renderModel(PoseStack poseStack, BakedModel model, int x, int y, int color) {
        ModelRender.renderModel(poseStack, ItemDisplayContext.GUI, model, x, y, color);
    }

    public static void renderModel(PoseStack poseStack, ItemDisplayContext transform, BakedModel model, int x, int y, int color) {
        boolean flag;
        Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_252880_((float)x, (float)y, 100.0f);
        posestack.m_252880_(8.0f, 8.0f, 0.0f);
        posestack.m_85841_(1.0f, -1.0f, 1.0f);
        posestack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack matrixstack = new PoseStack();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        model = ModelRender.handleCameraTransforms(matrixstack, model, transform, false);
        boolean bl = flag = !model.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        ModelRender.renderModel(matrixstack, RenderType.m_110463_(), buffer, model, color);
        buffer.m_109911_();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.m_84931_();
        }
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public static void renderModel(PoseStack poseStack, BlockState state, BakedModel model, int x, int y, int color) {
        Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85836_();
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_252880_((float)x, (float)y, 100.0f);
        posestack.m_252880_(8.0f, 8.0f, 0.0f);
        posestack.m_85841_(1.0f, -1.0f, 1.0f);
        posestack.m_85841_(16.0f, 16.0f, 16.0f);
        PoseStack matrix = new PoseStack();
        matrix.m_85836_();
        matrix.m_85837_(-0.75, 0.0, 0.0);
        float f = (float)java.lang.Math.toRadians(30.0);
        float g = (float)java.lang.Math.toRadians(0.0);
        float i = Math.sin((float)(0.5f * f));
        float j = Math.cos((float)(0.5f * f));
        float k = Math.sin((float)(0.5f * g));
        float l = Math.cos((float)(0.5f * g));
        float m = Math.sin((float)(0.5f * g));
        float n = Math.cos((float)(0.5f * g));
        matrix.m_252781_(new Quaternionf(30.0f, 30.0f, 0.0f, j * l * n - i * k * m));
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Minecraft.m_91087_().m_91289_().m_110912_(state, matrix, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_);
        matrix.m_85849_();
        buffer.m_109911_();
        RenderSystem.enableDepthTest();
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    private static void renderModel(PoseStack matrix, RenderType rendertype, MultiBufferSource.BufferSource buffer, BakedModel model, int color) {
        matrix.m_85836_();
        matrix.m_85837_(-0.5, -0.5, -0.5);
        VertexConsumer builder = ModelRender.getBuffer((MultiBufferSource)buffer, rendertype, true, false);
        ModelRender.renderModel(model, matrix, builder, color);
        matrix.m_85849_();
    }

    private static void renderModel(BakedModel modelIn, PoseStack matrix, VertexConsumer buffer, int color) {
        RandomSource random = RandomSource.m_216327_();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.m_188584_(42L);
            ModelRender.renderQuads(matrix, buffer, modelIn.m_213637_(null, direction, random), color);
        }
        random.m_188584_(42L);
        ModelRender.renderQuads(matrix, buffer, modelIn.m_213637_(null, null, random), color);
    }

    private static void renderQuads(PoseStack matrix, VertexConsumer buffer, List<BakedQuad> quads, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        PoseStack.Pose entry = matrix.m_85850_();
        for (BakedQuad bakedquad : quads) {
            ModelRender.render(buffer, bakedquad, entry, r, g, b, 1.0f);
        }
    }

    private static void render(VertexConsumer bufferIn, BakedQuad quadIn, PoseStack.Pose entry, float red, float green, float blue, float alpha) {
        int[] aint = quadIn.m_111303_();
        Vec3i vec3i = quadIn.m_111306_().m_122436_();
        Vector3f vector3f = new Vector3f((float)vec3i.m_123341_(), (float)vec3i.m_123342_(), (float)vec3i.m_123343_());
        Matrix4f matrix4f = entry.m_252922_();
        vector3f.mul((Matrix3fc)entry.m_252943_());
        int i = 8;
        int j = aint.length / 8;
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormat.f_85811_.m_86020_());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int k = 0; k < j; ++k) {
                intbuffer.clear();
                intbuffer.put(aint, k * 8, 8);
                float f = bytebuffer.getFloat(0);
                float f1 = bytebuffer.getFloat(4);
                float f2 = bytebuffer.getFloat(8);
                int l = java.lang.Math.min(k, lightmap.length - 1);
                int light = ModelRender.applyBakedLighting(lightmap[l], bytebuffer);
                float u = bytebuffer.getFloat(16);
                float v = bytebuffer.getFloat(20);
                Vector4f vector4f = new Vector4f(f, f1, f2, 1.0f);
                vector4f.mul((Matrix4fc)matrix4f);
                ModelRender.applyBakedNormals(vector3f, bytebuffer, entry.m_252943_());
                bufferIn.m_5954_(vector4f.x, vector4f.y, vector4f.z, red, green, blue, alpha, u, v, OverlayTexture.f_118083_, light, vector3f.x, vector3f.y, vector3f.z);
            }
        }
    }

    private static int applyBakedLighting(int lightmapCoord, ByteBuffer data) {
        int bl = LightTexture.m_109883_((int)lightmapCoord);
        int sl = LightTexture.m_109894_((int)lightmapCoord);
        int offset = 24;
        int blBaked = Short.toUnsignedInt(data.getShort(offset)) >> 4;
        int slBaked = Short.toUnsignedInt(data.getShort(offset + 2)) >> 4;
        bl = java.lang.Math.max(bl, blBaked);
        sl = java.lang.Math.max(sl, slBaked);
        return LightTexture.m_109885_((int)bl, (int)sl);
    }

    private static void applyBakedNormals(Vector3f generated, ByteBuffer data, Matrix3f normalTransform) {
        byte nx = data.get(28);
        byte ny = data.get(29);
        byte nz = data.get(30);
        if (nx != 0 || ny != 0 || nz != 0) {
            generated.set((float)nx / 127.0f, (float)ny / 127.0f, (float)nz / 127.0f);
            generated.mul((Matrix3fc)normalTransform);
        }
    }

    public static VertexConsumer getBuffer(MultiBufferSource buffer, RenderType type, boolean isItemIn, boolean dummy) {
        return buffer.m_6299_(type);
    }

    public static BakedModel handleCameraTransforms(PoseStack poseStack, BakedModel model, ItemDisplayContext cameraTransformType, boolean leftHandHackery) {
        PoseStack stack = new PoseStack();
        model.m_7442_().m_269404_(cameraTransformType).m_111763_(true, stack);
        if (!stack.m_85851_()) {
            Matrix4f tMat = stack.m_85850_().m_252922_();
            Matrix3f nMat = stack.m_85850_().m_252943_();
            if (leftHandHackery) {
                flipX.mul((Matrix4fc)tMat);
                tMat.mul((Matrix4fc)flipX);
                flipXNormal.mul((Matrix3fc)nMat);
                nMat.mul((Matrix3fc)flipXNormal);
            }
            poseStack.m_85850_().m_252922_().mul((Matrix4fc)tMat);
            poseStack.m_85850_().m_252943_().mul((Matrix3fc)nMat);
        }
        return model;
    }
}

