/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.gui.palette.texture;

import com.conquestreforged.client.gui.palette.texture.ItemGroup;
import com.conquestreforged.client.gui.palette.texture.TextureGroup;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class TextureGroupManager {
    private static final RandomSource random = RandomSource.m_216327_();
    private static final MeshDefinition nodata = new MeshDefinition();
    private static final TextureGroupManager INSTANCE = new TextureGroupManager();
    private final Map<Item, ItemGroup> blockGroups = new HashMap<Item, ItemGroup>();
    private final Map<String, TextureGroup> textureGroups = new HashMap<String, TextureGroup>();

    public ItemGroup getGroup(Block block) {
        return this.getGroup(block.m_5456_());
    }

    public ItemGroup getGroup(BlockState state) {
        return this.getGroup(state.m_60734_());
    }

    public ItemGroup getGroup(ItemStack stack) {
        return this.getGroup(stack.m_41720_());
    }

    public ItemGroup getGroup(Item item) {
        return this.blockGroups.getOrDefault(item, ItemGroup.NONE);
    }

    private void rebuild() {
        this.textureGroups.clear();
        this.blockGroups.clear();
        for (Item item : BuiltInRegistries.f_257033_) {
            if (!(item instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            this.addState(item, blockItem.m_40614_().m_49966_());
        }
    }

    private void addState(Item item, BlockState state) {
        Map<String, Integer> textures = TextureGroupManager.getTextures(state);
        int count = Integer.MAX_VALUE;
        TextureGroup main = null;
        LinkedList<TextureGroup> itemGroups = new LinkedList<TextureGroup>();
        for (Map.Entry<String, Integer> entry : textures.entrySet()) {
            TextureGroup textureGroup = this.textureGroups.computeIfAbsent(entry.getKey(), TextureGroup::new);
            textureGroup.add(item);
            itemGroups.add(textureGroup);
            if (entry.getValue() >= count) continue;
            main = textureGroup;
        }
        if (main != null) {
            this.blockGroups.put(item, new ItemGroup(main, itemGroups));
        }
    }

    private static Map<String, Integer> getTextures(BlockState state) {
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(state);
        return TextureGroupManager.getTextures(state, model);
    }

    private static Map<String, Integer> getTextures(BlockState state, @Nullable BakedModel model) {
        if (model == null || model == Minecraft.m_91087_().m_91304_().m_119409_()) {
            return Collections.emptyMap();
        }
        List quads = model.m_213637_(state, null, random);
        HashMap<String, Integer> textures = new HashMap<String, Integer>();
        TextureGroupManager.addTexture(model.m_6160_(), textures);
        for (BakedQuad quad : quads) {
            TextureGroupManager.addTexture(quad.m_173410_(), textures);
        }
        return textures;
    }

    private static void addTexture(@Nullable TextureAtlasSprite sprite, Map<String, Integer> textures) {
        String texture = TextureGroupManager.getTextureName(sprite);
        if (!texture.isEmpty()) {
            int count = textures.getOrDefault(texture, 0);
            textures.put(texture, count + 1);
        }
    }

    private static String getTextureName(@Nullable TextureAtlasSprite sprite) {
        if (sprite != null) {
            try {
                return TextureGroupManager.getResourceName(sprite.m_247685_());
            }
            catch (Throwable t) {
                return "";
            }
        }
        return "";
    }

    private static String getResourceName(@Nullable ResourceLocation location) {
        if (location != null) {
            return location.toString();
        }
        return "";
    }

    public static TextureGroupManager getInstance() {
        return INSTANCE;
    }
}

