/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.gui.palette.component;

import com.conquestreforged.client.gui.palette.component.ColorPicker;
import com.conquestreforged.client.gui.palette.component.Panel;
import com.conquestreforged.client.gui.render.ColorUtils;
import com.conquestreforged.client.gui.render.Curve;
import com.conquestreforged.core.config.ConfigBuildEvent;
import com.conquestreforged.core.config.section.ConfigSection;
import com.conquestreforged.core.config.section.ConfigSectionSpec;
import com.conquestreforged.core.init.dev.Environment;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class PaletteSettings
extends Screen {
    private static final boolean test = false;
    private static ConfigSection config;
    public transient Curve zoomCurve = Curve.SQUARE;
    public float zoomScale = config.getAsFloat("zoom_scale", 1.1);
    public float zoomSpread = config.getAsFloat("zoom_spread", 1.0);
    public float highlightScale = config.getAsFloat("highlight_scale", 1.1);
    public int highlightColor = ColorUtils.fromHex((String)config.get("highlight_color"));
    public int hoveredColor = ColorUtils.fromHex((String)config.get("hovered_color"));
    public int selectedColor = ColorUtils.fromHex((String)config.get("selected_color"));
    private final Panel left = Panel.left(true);
    private final Panel right = Panel.right(true);

    public PaletteSettings() {
        super((Component)Component.m_237113_((String)"Settings"));
    }

    protected void m_7856_() {
        this.dispose();
        super.m_7856_();
        if (!Environment.isProduction()) {
            // empty if block
        }
    }

    public void m_88315_(GuiGraphics matrixStack, int mx, int my, float ticks) {
        this.left.tick();
        this.right.tick();
        super.m_88315_(matrixStack, mx, my, ticks);
    }

    public void m_7861_() {
        this.dispose();
        config.save();
    }

    public void m_7379_() {
        super.m_7379_();
        this.dispose();
        config.save();
    }

    private void dispose() {
        for (Renderable widget : this.f_169369_) {
            if (!(widget instanceof ColorPicker)) continue;
            ((ColorPicker)widget).dispose();
        }
    }

    private void add(Panel panel, AbstractWidget widget) {
        super.m_142416_((GuiEventListener)widget);
        panel.add(widget);
    }

    @SubscribeEvent
    public static void config(ConfigBuildEvent event) {
        try (ConfigSectionSpec spec = event.client("palette", new String[0]);){
            spec.getBuilder().comment("Controls how large items get when your cursor moves towards them");
            spec.getBuilder().define("zoom_scale", (Object)1.1).next();
            spec.getBuilder().comment("Controls the number of items that are affected by the zoom effect");
            spec.getBuilder().defineInRange("zoom_spread", 1.0, 0.0, 1.0).next();
            spec.getBuilder().comment("Controls the size of the colored highlight around items");
            spec.getBuilder().defineInRange("highlight_size", 1.1, 1.0, 2.0).next();
            spec.getBuilder().comment("The highlight color around idle items");
            spec.getBuilder().define("highlight_color", (Object)ColorUtils.toHex(Color.BLACK)).next();
            spec.getBuilder().comment("The highlight color around the item under your cursor");
            spec.getBuilder().define("hovered_color", (Object)ColorUtils.toHex(Color.GRAY)).next();
            spec.getBuilder().comment("The highlight color around the selected/dragged item");
            spec.getBuilder().define("selected_color", (Object)ColorUtils.toHex(Color.WHITE)).next();
            config = spec.getSection();
        }
    }

    private /* synthetic */ void lambda$init$2(Integer c) {
        this.selectedColor = c;
    }

    private /* synthetic */ void lambda$init$1(Integer c) {
        this.hoveredColor = c;
    }

    private /* synthetic */ void lambda$init$0(Integer c) {
        this.highlightColor = c;
    }
}

