/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.gui.palette;

import com.conquestreforged.core.init.dev.Environment;
import com.conquestreforged.core.item.family.Family;
import com.conquestreforged.core.item.family.FamilyRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class Palette {
    public static Container createPalette(ItemStack first, List<ItemStack> family) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(family.size());
        result.add(Palette.copyOne(first));
        for (ItemStack stack : family) {
            if (ItemStack.m_41656_((ItemStack)stack, (ItemStack)first) && ItemStack.m_41728_((ItemStack)first, (ItemStack)stack)) continue;
            result.add(Palette.copyOne(stack));
        }
        return new SimpleContainer(result.toArray(new ItemStack[0]));
    }

    public static Optional<Container> getPalette(ItemStack stack) {
        return Palette.getPalette(stack, stack.m_41720_());
    }

    private static Optional<Container> getPalette(ItemStack stack, Item item) {
        if (item instanceof BlockItem) {
            return Palette.getPalette(stack, ((BlockItem)item).m_40614_());
        }
        return Optional.empty();
    }

    private static Optional<Container> getPalette(ItemStack stack, Block block) {
        if (block == Blocks.f_50016_) {
            return Optional.empty();
        }
        Family<Block> family = FamilyRegistry.BLOCKS.getFamily(block);
        if (family.isAbsent()) {
            if (Environment.isProduction()) {
                return Optional.empty();
            }
            return Optional.of(Palette.createPalette(stack, Palette.createDebugPalette(5, 50)));
        }
        NonNullList items = NonNullList.m_122779_();
        family.addAllItems(family.getGroup(), (NonNullList<ItemStack>)items);
        return Optional.of(Palette.createPalette(stack, (List<ItemStack>)items));
    }

    private static List<ItemStack> createDebugPalette(int min, int max) {
        Random random = new Random(System.currentTimeMillis());
        int size = min + random.nextInt(max - min);
        NonNullList items = NonNullList.m_122779_();
        ArrayList blocks = new ArrayList(BuiltInRegistries.f_256975_.m_123024_().toList());
        while (items.size() < size) {
            int index = random.nextInt(blocks.size());
            ItemStack itemStack = new ItemStack((ItemLike)blocks.get(index));
            if (itemStack.m_41619_()) continue;
            items.add((Object)itemStack);
        }
        return items;
    }

    private static ItemStack copyOne(ItemStack stack) {
        stack = stack.m_41777_();
        stack.m_41764_(1);
        return stack;
    }
}

