/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.gui.intro;

import com.conquestreforged.client.BindManager;
import com.conquestreforged.client.tutorial.Tutorials;
import com.conquestreforged.client.utils.TextUtils;
import com.conquestreforged.core.config.section.ConfigSection;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class IntroScreen
extends Screen {
    private static final ResourceLocation LOGO = new ResourceLocation("conquest:textures/gui/intro/logosmall.png");
    private static final int LOGO_HEIGHT = 100;
    private static final int LOGO_WIDTH = 100;
    private final Screen screen;
    private final ConfigSection section;
    private final Checkbox check = new Checkbox(0, 0, 20, 20, (Component)Component.m_264568_((String)"conquest.intro.checkbox", (String)"Do not show again"), false);

    public IntroScreen(Screen parent, ConfigSection section) {
        super((Component)Component.m_237113_((String)"Intro"));
        this.screen = parent;
        this.section = section;
    }

    public boolean m_6913_() {
        return true;
    }

    public void m_7379_() {
        this.section.set("ignore_intro", (Object)this.check.m_93840_());
        this.section.save();
        Minecraft.m_91087_().m_91152_(this.screen);
    }

    protected void m_7856_() {
        Tutorials.intro = true;
        super.m_7856_();
        int center = this.f_96543_ / 2;
        this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_264568_((String)"conquest.intro.close", (String)"Continue"), b -> this.m_7379_()).m_252987_(center - 50, this.f_96544_ - 24, 100, 20).m_253136_());
        this.check.m_253211_(this.f_96544_ - 24);
        this.check.m_252865_(center + 50 + 8);
        this.m_142416_((GuiEventListener)this.check);
    }

    public void m_88315_(GuiGraphics drawContext, int mx, int my, float ticks) {
        this.m_280039_(drawContext);
        MutableComponent paletteKeyLetter = Component.m_237113_((String)BindManager.getPaletteBind().m_90863_().getString().toUpperCase()).m_130940_(ChatFormatting.GOLD);
        MutableComponent blockstateSelectorKeyLetter = Component.m_264568_((String)"conquest.intro.pickblock", (String)"CTRL+MIDDLE-MOUSE-BUTTON").m_130940_(ChatFormatting.GOLD);
        MutableComponent welcomeString = Component.m_264568_((String)"conquest.intro.welcome", (String)"Welcome to Conquest Reforged!").m_130940_(ChatFormatting.GOLD);
        Component[] messageOriginal = new Component[]{welcomeString, Component.m_264568_((String)"conquest.intro.1", (String)"This screen will introduce you to keybinds for making building faster."), Component.m_237113_((String)""), Component.m_237113_((String)"\"").m_7220_((Component)paletteKeyLetter).m_130946_("\"").m_7220_((Component)Component.m_264568_((String)"conquest.intro.2", (String)" - (Creative Mode only) shows texture shape variants in the block palette.")), Component.m_264568_((String)"conquest.intro.3", (String)"Works while hovering over a block in the creative menu or when selected in the hotbar."), Component.m_237113_((String)""), Component.m_237113_((String)"\"").m_7220_((Component)blockstateSelectorKeyLetter).m_130946_("\"").m_7220_((Component)Component.m_264568_((String)"conquest.intro.4", (String)" - (Creative Mode only) press while looking at a block.")), Component.m_264568_((String)"conquest.intro.5", (String)"This gives the exact shape you're looking at as a block item in your hotbar. Holding ALT as well will copy the exact direction of the block too.")};
        int maxWidth = (int)((double)this.f_96543_ * 0.95);
        ArrayList<Component> wrappedLines = new ArrayList<Component>();
        for (Component line : messageOriginal) {
            if (this.f_96547_.m_92852_((FormattedText)line) <= maxWidth) {
                wrappedLines.add(line);
                continue;
            }
            TextUtils.wrapComplexTextToList(line, this.f_96547_, maxWidth, wrappedLines);
        }
        Component[] message = wrappedLines.toArray(new Component[0]);
        int dist = 12;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LOGO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        drawContext.m_280411_(LOGO, this.getImageLeft(35), 15, 35, 35, 0.0f, 0.0f, 100, 100, 100, 100);
        for (int i = 0; i < message.length; ++i) {
            int titleWidth = this.f_96547_.m_92852_((FormattedText)message[i]);
            int titleOffset = titleWidth / 2;
            drawContext.m_280648_(this.f_96547_, message[i].m_7532_(), (int)((float)this.f_96543_ / 2.0f - (float)titleOffset), 70 + i * dist, 0xFFFFFF);
        }
        super.m_88315_(drawContext, mx, my, ticks);
    }

    private int getImageLeft(int imageWidth) {
        return this.f_96543_ / 2 - imageWidth / 2;
    }
}

