/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.gui.dependency.screen;

import com.conquestreforged.client.gui.dependency.Dependency;
import com.conquestreforged.client.gui.dependency.DependencyType;
import com.conquestreforged.client.tutorial.Tutorials;
import com.conquestreforged.client.utils.TextUtils;
import com.conquestreforged.core.config.section.ConfigSection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class DependencyScreen
extends Screen {
    private static final ResourceLocation CTM = new ResourceLocation("conquest:textures/gui/dependency/ctm.png");
    private static final int CTM_HEIGHT = 256;
    private static final int CTM_WIDTH = 432;
    private static final int LIST_HEIGHT = 64;
    private static final int TITLE_HEIGHT = 22;
    private static final int MARGIN_TOP = 10;
    private static final int MARGIN_BOTTOM = 28;
    private final Screen screen;
    private final ConfigSection section;
    private final List<Dependency> missing;
    private final Checkbox check = new Checkbox(0, 0, 20, 20, (Component)Component.m_264568_((String)"conquest.dependency.checkbox", (String)"Do not show again"), false);

    public DependencyScreen(Screen parent, ConfigSection section, List<Dependency> missing) {
        super(Component.m_130674_((String)"Dependencies"));
        this.screen = parent;
        this.section = section;
        this.missing = missing;
    }

    public boolean m_6913_() {
        return true;
    }

    public void m_7379_() {
        this.section.set("ignore_dependencies", (Object)this.check.m_93840_());
        this.section.save();
        Minecraft.m_91087_().m_91152_(this.screen);
    }

    protected void m_7856_() {
        Tutorials.dependencies = true;
        super.m_7856_();
        int center = this.f_96543_ / 2;
        int imageHeight = this.getImageHeight();
        int imageWidth = this.getImageWidth(imageHeight);
        int paddingTop = this.getPaddingTop(imageHeight);
        int listTop = paddingTop + imageHeight;
        int listBottom = listTop + 22 + 64;
        this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237110_((String)"conquest.dependency.close", (Object[])new Object[]{"Continue"}), b -> this.m_7379_()).m_252987_(center - 50, this.f_96544_ - 24, 100, 20).m_253136_());
        this.check.m_253211_(this.f_96544_ - 24);
        this.check.m_252865_(center + 50 + 8);
        this.m_142416_((GuiEventListener)this.check);
        if (!this.section.getOrElse("using_modpack", Boolean.valueOf(false)).booleanValue()) {
            int topDist = 7;
            Component[] recommendationOriginal = new Component[]{Component.m_264568_((String)"conquest.dependency.1", (String)"It appears you're not using the Conquest Reforged Modpack!").m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)""), Component.m_264568_((String)"conquest.dependency.2", (String)"Our modpack adds all of the required dependencies,"), Component.m_264568_((String)"conquest.dependency.3", (String)"along with optimization mods and proper configs for the best experience."), Component.m_264568_((String)"conquest.dependency.4", (String)"Getting all of the right versions of every mod is hard, this takes care of that for you."), Component.m_264568_((String)"conquest.dependency.5", (String)"If you're making your own modpack, you can use ours as a base."), Component.m_264568_((String)"conquest.dependency.6", (String)"Otherwise, this screen will show you which of the most essential dependencies are missing.")};
            int maxWidth = (int)((double)this.f_96543_ * 0.95);
            ArrayList<Component> wrappedLines = new ArrayList<Component>();
            for (Component line : recommendationOriginal) {
                if (this.f_96547_.m_92852_((FormattedText)line) <= maxWidth) {
                    wrappedLines.add(line);
                    continue;
                }
                TextUtils.wrapComplexTextToList(line, this.f_96547_, maxWidth, wrappedLines);
            }
            int dist = 12;
            for (int i = 0; i < wrappedLines.size(); ++i) {
                topDist += dist;
            }
            this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_264568_((String)"conquest.dependency.modpack", (String)"Modpack"), btn -> {
                try {
                    Util.m_137581_().m_137650_(new URL("https://modrinth.com/modpack/conquest-reforged-modpack"));
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }).m_252987_(center - 85, topDist += 12, 170, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_264568_((String)"conquest.dependency.tooltip.modpack", (String)"Page for the Modpack is here, install via ATLauncher or Modrinth launcher!"))).m_253136_());
        }
        int bottomDist = this.f_96544_ - 50;
        int buttonsPerRow = 3;
        int buttonWidth = 120;
        if (this.missing.size() > buttonsPerRow) {
            bottomDist -= 24;
        }
        for (int i = 0; i < this.missing.size(); ++i) {
            int row = i / buttonsPerRow;
            int col = i % buttonsPerRow;
            int buttonsInThisRow = Math.min(buttonsPerRow, this.missing.size() - row * buttonsPerRow);
            int rowWidth = buttonsInThisRow * buttonWidth;
            int rowLeftEdge = center - rowWidth / 2;
            int xPosition = rowLeftEdge + col * buttonWidth + buttonWidth / 2;
            int yPosition = bottomDist + row * 24;
            this.m_142416_((GuiEventListener)DependencyScreen.createButton(this.missing.get(i), yPosition, xPosition));
        }
    }

    public void m_88315_(GuiGraphics drawContext, int mx, int my, float ticks) {
        this.m_280273_(drawContext);
        int center = this.f_96543_ / 2;
        int imageHeight = this.getImageHeight();
        int imageWidth = this.getImageWidth(imageHeight);
        int imageLeft = this.getImageLeft(imageWidth);
        int paddingTop = this.getPaddingTop(imageHeight);
        if (!this.section.getOrElse("using_modpack", Boolean.valueOf(false)).booleanValue()) {
            Component[] recommendationOriginal = new Component[]{Component.m_264568_((String)"conquest.dependency.1", (String)"It appears you're not using the Conquest Reforged Modpack!").m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)""), Component.m_264568_((String)"conquest.dependency.2", (String)"Our modpack adds all of the required dependencies,"), Component.m_264568_((String)"conquest.dependency.3", (String)"along with optimization mods and proper configs for the best experience."), Component.m_264568_((String)"conquest.dependency.4", (String)"Getting all of the right versions of every mod is hard, this takes care of that for you."), Component.m_264568_((String)"conquest.dependency.5", (String)"If you're making your own modpack, you can use ours as a base."), Component.m_264568_((String)"conquest.dependency.6", (String)"Otherwise, this screen will show you which of the most essential dependencies are missing.")};
            int maxWidth = (int)((double)this.f_96543_ * 0.95);
            ArrayList<Component> wrappedLines = new ArrayList<Component>();
            for (Component line : recommendationOriginal) {
                if (this.f_96547_.m_92852_((FormattedText)line) <= maxWidth) {
                    wrappedLines.add(line);
                    continue;
                }
                TextUtils.wrapComplexTextToList(line, this.f_96547_, maxWidth, wrappedLines);
            }
            int topDist = 7;
            int dist = 12;
            for (int i = 0; i < wrappedLines.size(); ++i) {
                int paragraphWidth = this.f_96547_.m_92852_((FormattedText)wrappedLines.get(i));
                int paragraphOffset = paragraphWidth / 2;
                drawContext.m_280648_(this.f_96547_, ((Component)wrappedLines.get(i)).m_7532_(), (int)((float)this.f_96543_ / 2.0f - (float)paragraphOffset), topDist += dist, 0xFFFFFF);
            }
        }
        int bottomDist = this.f_96544_ - 50;
        if (this.missing.size() > 3) {
            bottomDist -= 24;
        }
        MutableComponent message = Component.m_264568_((String)"conquest.dependency.missing", (String)"Missing Dependencies:").m_130940_(ChatFormatting.GOLD);
        int titleWidth = this.f_96547_.m_92852_((FormattedText)message);
        int titleOffset = titleWidth / 2;
        drawContext.m_280430_(this.f_96547_, (Component)message, (int)((float)this.f_96543_ / 2.0f - (float)titleOffset), bottomDist - 14, 0xFFFFFF);
        super.m_88315_(drawContext, mx, my, ticks);
    }

    private int getImageHeight() {
        return Math.min(256, this.f_96544_ - 10 - 22 - 64 - 28);
    }

    private int getImageWidth(int imageHeight) {
        return Math.round(432.0f * ((float)imageHeight / 256.0f));
    }

    private int getImageLeft(int imageWidth) {
        return this.f_96543_ / 2 - imageWidth / 2;
    }

    private int getPaddingTop(int imageHeight) {
        int elementsHeight = imageHeight + 22 + 64;
        int paddingTop = (this.f_96544_ - elementsHeight) / 2;
        int dif = this.f_96544_ - (paddingTop + elementsHeight);
        if (dif < 28) {
            paddingTop -= dif;
            paddingTop = Math.max(paddingTop, 2);
        }
        return paddingTop;
    }

    private static Button createButton(Dependency dependency, int heightIn, int center) {
        return new Button.Builder((Component)Component.m_237115_((String)dependency.getDisplayName()), btn -> {
            try {
                if (dependency.getType() == DependencyType.RESOURCEPACK) {
                    return;
                }
                Util.m_137581_().m_137650_(new URL(dependency.getURL()));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }).m_252987_(center - 60, heightIn, 120, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)("conquest.dependency.tooltip." + dependency.getId())))).m_253136_();
    }
}

