/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.gui.dependency;

import com.conquestreforged.client.gui.dependency.Dependency;
import com.conquestreforged.client.gui.dependency.PackIdDeserializer;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.repository.Pack;
import net.minecraftforge.fml.ModList;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DependencyType {
    UNKNOWN{

        @Override
        public boolean isAvailable(Dependency dependency) {
            return true;
        }
    }
    ,
    MOD{

        @Override
        public boolean isAvailable(Dependency dependency) {
            return ModList.get().isLoaded(dependency.getId());
        }
    }
    ,
    LIB{

        @Override
        public boolean isAvailable(Dependency dependency) {
            try {
                Class.forName(dependency.getId());
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
    }
    ,
    RESOURCEPACK{

        @Override
        public boolean isAvailable(Dependency dependency) {
            for (Pack pack : Minecraft.m_91087_().m_91099_().m_10524_()) {
                try {
                    Object packId = pack.m_10445_().m_5550_((MetadataSectionSerializer)PackIdDeserializer.INSTANCE);
                    if (!dependency.getId().equalsIgnoreCase(String.valueOf(packId))) continue;
                    return true;
                }
                catch (IOException iOException) {
                }
            }
            return false;
        }
    };


    public abstract boolean isAvailable(Dependency var1);

    static DependencyType of(String name) {
        for (DependencyType type : DependencyType.values()) {
            if (!type.name().equalsIgnoreCase(name)) continue;
            return type;
        }
        return UNKNOWN;
    }
}

