/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.gui;

import com.conquestreforged.client.gui.palette.component.Style;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class CustomContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    private ResourceLocation SLOT_BACKGROUND = new ResourceLocation("conquest:textures/gui/picker/slot.png");
    private Slot clickedSlot;
    private boolean isRightMouseClick;
    private boolean isOverSlot = false;

    public CustomContainerScreen(T screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
    }

    protected void onSlotClick(@Nullable Slot slot, int index, int button, ClickType type) {
        this.clickedSlot = slot;
        this.isRightMouseClick = button == 2;
    }

    protected void m_6597_(@Nullable Slot slot, int index, int button, ClickType type) {
        super.m_6597_(slot, index, button, type);
        this.onSlotClick(slot, index, button, type);
    }

    protected void setupRender(PoseStack poseStack) {
        this.isOverSlot = false;
        RenderSystem.enableBlend();
        poseStack.m_85836_();
        poseStack.m_252880_((float)this.f_97735_, (float)this.f_97736_, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void tearDownRender(PoseStack poseStack) {
        poseStack.m_85849_();
        RenderSystem.disableBlend();
    }

    public void renderDraggedItem(GuiGraphics drawContext, int mx, int my, float depth, Style style) {
        int zlevel = 250;
        ItemStack held = this.m_6262_().m_142621_();
        if (!held.m_41619_()) {
            PoseStack posestack = drawContext.m_280168_();
            posestack.m_85836_();
            RenderSystem.disableBlend();
            posestack.m_252880_((float)mx, (float)my, (float)zlevel);
            drawContext.m_280480_(held, -8, -8);
            drawContext.m_280370_(this.f_96547_, held, -8, -8);
            posestack.m_85849_();
            RenderSystem.enableDepthTest();
        }
    }

    public void renderSlotBackGround(GuiGraphics drawContext, Slot slot, Style style, float depth, float scale) {
        int x = slot.f_40220_ + 8;
        int y = slot.f_40221_ + 8;
        drawContext.m_280168_().m_85836_();
        drawContext.m_280168_().m_252880_((float)x, (float)y, 1.0f);
        drawContext.m_280168_().m_85841_(scale, scale, 1.0f);
        if (style != null && style.background != null) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)style.background);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            drawContext.m_280411_(this.SLOT_BACKGROUND, -8, -6, 16, 16, 0.0f, 0.0f, 72, 72, 72, 72);
        }
        drawContext.m_280168_().m_85849_();
    }

    public void renderSlot(GuiGraphics drawContext, Slot slot, int mx, int my, float depth, float scale) {
        this.renderSlot(drawContext, slot, null, mx, my, depth, scale);
    }

    public void renderSlot(GuiGraphics drawContext, Slot slot, Style style, int mx, int my, float depth, float scale) {
        int x = slot.f_40220_ + 8;
        int y = slot.f_40221_ + 8;
        int zlevel = depth == 1.0f ? 60 : 0;
        ItemStack itemstack = slot.m_7993_();
        PoseStack posestack = drawContext.m_280168_();
        posestack.m_85836_();
        RenderSystem.disableBlend();
        posestack.m_252880_((float)x, (float)y, 1.0f);
        posestack.m_85841_(scale, scale, 1.0f);
        drawContext.m_280480_(itemstack, -8, -8);
        drawContext.m_280302_(this.f_96547_, itemstack, -8, -8, null);
        posestack.m_85849_();
        RenderSystem.enableDepthTest();
    }

    public static boolean isMouseOver(Slot slot, int mx, int my, int size, float scale) {
        float delta = (float)size * scale;
        return (float)mx >= (float)slot.f_40220_ - delta && (float)mx <= (float)slot.f_40220_ + delta && (float)my >= (float)slot.f_40221_ - delta && (float)my <= (float)slot.f_40221_ + delta;
    }
}

