/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.startup;

import mezz.jei.fabric.events.JeiCharTypedEvents;
import mezz.jei.fabric.events.JeiScreenEvents;
import mezz.jei.gui.events.GuiEventHandler;
import mezz.jei.gui.input.ClientInputHandler;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.startup.JeiEventHandlers;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import org.jetbrains.annotations.Nullable;

public class EventRegistration {
    @Nullable
    private ClientInputHandler clientInputHandler;
    @Nullable
    private GuiEventHandler guiEventHandler;
    private boolean registered;

    public void setEventHandlers(JeiEventHandlers eventHandlers) {
        this.clientInputHandler = eventHandlers.clientInputHandler();
        this.guiEventHandler = eventHandlers.guiEventHandler();
        if (!this.registered) {
            this.registerEvents();
            this.registered = true;
        }
    }

    private void registerEvents() {
        ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> this.registerScreenEvents(screen));
        JeiCharTypedEvents.BEFORE_CHAR_TYPED.register(this::beforeCharTyped);
        ScreenEvents.AFTER_INIT.register(this::afterInit);
        JeiScreenEvents.AFTER_RENDER_BACKGROUND.register(this::afterRenderBackground);
        JeiScreenEvents.DRAW_FOREGROUND.register(this::drawForeground);
        ClientTickEvents.START_CLIENT_TICK.register(this::onStartTick);
    }

    private void registerScreenEvents(Screen screen) {
        if (this.guiEventHandler == null) {
            return;
        }
        ScreenKeyboardEvents.allowKeyPress((Screen)screen).register(this::allowKeyPress);
        ScreenMouseEvents.allowMouseClick((Screen)screen).register(this::allowMouseClick);
        ScreenMouseEvents.allowMouseRelease((Screen)screen).register(this::allowMouseRelease);
        ScreenMouseEvents.allowMouseScroll((Screen)screen).register(this::allowMouseScroll);
        ScreenEvents.afterRender((Screen)screen).register(this::afterRender);
    }

    private boolean allowMouseClick(Screen screen, double mouseX, double mouseY, int button) {
        if (this.clientInputHandler == null) {
            return true;
        }
        return UserInput.fromVanilla(mouseX, mouseY, button, InputType.SIMULATE).map(input -> !this.clientInputHandler.onGuiMouseClicked(screen, (UserInput)input)).orElse(true);
    }

    private boolean allowMouseRelease(Screen screen, double mouseX, double mouseY, int button) {
        if (this.clientInputHandler == null) {
            return true;
        }
        return UserInput.fromVanilla(mouseX, mouseY, button, InputType.EXECUTE).map(input -> !this.clientInputHandler.onGuiMouseReleased(screen, (UserInput)input)).orElse(true);
    }

    private boolean allowKeyPress(Screen screen, int key, int scancode, int modifiers) {
        if (this.clientInputHandler == null) {
            return true;
        }
        UserInput userInput = UserInput.fromVanilla(key, scancode, modifiers, InputType.IMMEDIATE);
        return !this.clientInputHandler.onKeyboardKeyPressedPre(screen, userInput);
    }

    private boolean allowMouseScroll(Screen screen, double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.clientInputHandler == null) {
            return false;
        }
        return !this.clientInputHandler.onGuiMouseScroll(mouseX, mouseY, verticalAmount);
    }

    private void afterRender(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float tickDelta) {
        if (this.guiEventHandler != null) {
            this.guiEventHandler.onDrawScreenPost(screen, guiGraphics, mouseX, mouseY);
        }
    }

    private boolean beforeCharTyped(GuiEventListener guiEventListener, char codepoint, int modifiers) {
        if (this.clientInputHandler != null && guiEventListener instanceof Screen) {
            Screen screen = (Screen)guiEventListener;
            return this.clientInputHandler.onKeyboardCharTypedPre(screen, codepoint, modifiers);
        }
        return false;
    }

    private void afterInit(Minecraft client, Screen screen, int scaledWidth, int scaledHeight) {
        if (this.guiEventHandler != null) {
            this.guiEventHandler.onGuiInit(screen);
            this.guiEventHandler.onGuiOpen(screen);
        }
    }

    private void afterRenderBackground(Screen screen, GuiGraphics guiGraphics) {
        if (this.guiEventHandler != null) {
            this.guiEventHandler.onDrawBackgroundPost(screen, guiGraphics);
        }
    }

    private void drawForeground(AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.guiEventHandler != null) {
            this.guiEventHandler.onDrawForeground(screen, guiGraphics, mouseX, mouseY);
        }
    }

    private void onStartTick(Minecraft client) {
        if (this.guiEventHandler != null) {
            this.guiEventHandler.onClientTick();
        }
    }

    public void clear() {
        this.clientInputHandler = null;
        this.guiEventHandler = null;
    }
}

