/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.platform;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.library.util.ResourceLocationUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;

public class RenderHelper
implements IPlatformRenderHelper {
    @Override
    public Font getFontRenderer(Minecraft minecraft, ItemStack itemStack) {
        return minecraft.f_91062_;
    }

    @Override
    public boolean shouldRender(MobEffectInstance potionEffect) {
        return true;
    }

    @Override
    public TextureAtlasSprite getParticleIcon(BakedModel bakedModel) {
        return bakedModel.m_6160_();
    }

    @Override
    public ItemColors getItemColors() {
        Minecraft minecraft = Minecraft.m_91087_();
        return minecraft.f_91041_;
    }

    @Override
    public Optional<NativeImage> getMainImage(TextureAtlasSprite sprite) {
        SpriteContents contents = sprite.m_245424_();
        NativeImage[] frames = contents.f_243731_;
        if (frames.length == 0) {
            return Optional.empty();
        }
        NativeImage frame = frames[0];
        return Optional.ofNullable(frame);
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, List<Either<FormattedText, TooltipComponent>> elements, int x, int y, Font font, ItemStack stack) {
        List components = elements.stream().flatMap(e -> (Stream)e.map(text -> font.m_92923_(text, 400).stream().map(ClientTooltipComponent::m_169948_), tooltipComponent -> Stream.of(this.createClientTooltipComponent((TooltipComponent)tooltipComponent)))).collect(Collectors.toCollection(ArrayList::new));
        guiGraphics.m_280497_(font, components, x, y, DefaultTooltipPositioner.f_262752_);
    }

    @Override
    public Component getName(TagKey<?> tagKey) {
        String tagTranslationKey = RenderHelper.getTagTranslationKey(tagKey);
        return Component.m_264568_((String)tagTranslationKey, (String)("#" + tagKey.f_203868_()));
    }

    private static String getTagTranslationKey(TagKey<?> tagKey) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("tag.");
        ResourceLocation registryIdentifier = tagKey.f_203867_().m_135782_();
        ResourceLocation tagIdentifier = tagKey.f_203868_();
        if (!registryIdentifier.m_135827_().equals("minecraft")) {
            stringBuilder.append(registryIdentifier.m_135827_()).append(".");
        }
        String registryId = ResourceLocationUtil.sanitizePath(registryIdentifier.m_135815_());
        String tagId = ResourceLocationUtil.sanitizePath(tagIdentifier.m_135815_());
        stringBuilder.append(registryId).append(".").append(tagIdentifier.m_135827_()).append(".").append(tagId);
        return stringBuilder.toString();
    }

    private ClientTooltipComponent createClientTooltipComponent(TooltipComponent tooltipComponent) {
        if (tooltipComponent instanceof ClientTooltipComponent) {
            ClientTooltipComponent clientTooltipComponent = (ClientTooltipComponent)tooltipComponent;
            return clientTooltipComponent;
        }
        return ClientTooltipComponent.m_169950_((TooltipComponent)tooltipComponent);
    }
}

