/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.platform;

import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.common.platform.IPlatformRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class RegistryWrapper<T>
implements IPlatformRegistry<T> {
    private final Registry<T> registry;

    public static <T> IPlatformRegistry<T> getRegistry(ResourceKey<? extends Registry<T>> key) {
        RegistryWrapper<T> registryWrapper;
        Registry rootRegistry = BuiltInRegistries.f_257047_;
        Registry registry = (Registry)rootRegistry.m_7745_(key.m_135782_());
        if (registry == null) {
            throw new NullPointerException("Could not find registry for key: " + key);
        }
        RegistryWrapper<T> castPlatformRegistry = registryWrapper = new RegistryWrapper<T>(registry);
        return castPlatformRegistry;
    }

    private RegistryWrapper(Registry<T> registry) {
        this.registry = registry;
    }

    @Override
    public Stream<T> getValues() {
        return this.registry.m_123024_();
    }

    @Override
    public Optional<T> getValue(ResourceLocation resourceLocation) {
        Object t = this.registry.m_7745_(resourceLocation);
        return Optional.ofNullable(t);
    }

    @Override
    public int getId(T entry) {
        return this.registry.m_7447_(entry);
    }

    @Override
    public Optional<T> getValue(int id) {
        return this.registry.m_203300_(id).map(Holder::m_203334_);
    }

    @Override
    public boolean contains(T entry) {
        return this.registry.m_7981_(entry) != null;
    }

    @Override
    public Optional<ResourceLocation> getRegistryName(T entry) {
        return this.registry.m_7854_(entry).map(ResourceKey::m_135782_);
    }
}

