/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.fabric.platform;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.fabric.ingredients.fluid.JeiFluidIngredient;
import mezz.jei.library.render.FluidTankRenderer;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class FluidHelper
implements IPlatformFluidHelperInternal<IJeiFluidIngredient> {
    @Override
    public IIngredientTypeWithSubtypes<Fluid, IJeiFluidIngredient> getFluidIngredientType() {
        return FabricTypes.FLUID_STACK;
    }

    @Override
    public IIngredientSubtypeInterpreter<IJeiFluidIngredient> getAllNbtSubtypeInterpreter() {
        return AllFluidNbt.INSTANCE;
    }

    @Override
    public IIngredientRenderer<IJeiFluidIngredient> createRenderer(long capacity, boolean showCapacity, int width, int height) {
        return new FluidTankRenderer<IJeiFluidIngredient>(this, capacity, showCapacity, width, height);
    }

    @Override
    public Optional<TextureAtlasSprite> getStillFluidSprite(IJeiFluidIngredient ingredient) {
        FluidVariant fluidVariant = this.getFluidVariant(ingredient);
        TextureAtlasSprite sprite = FluidVariantRendering.getSprite((FluidVariant)fluidVariant);
        return Optional.ofNullable(sprite);
    }

    @Override
    public Component getDisplayName(IJeiFluidIngredient ingredient) {
        FluidVariant fluidVariant = this.getFluidVariant(ingredient);
        Component displayName = FluidVariantAttributes.getName((FluidVariant)fluidVariant);
        Fluid fluid = fluidVariant.getFluid();
        if (!fluid.m_7444_(fluid.m_76145_())) {
            return Component.m_237110_((String)"jei.tooltip.liquid.flowing", (Object[])new Object[]{displayName});
        }
        return displayName;
    }

    @Override
    public int getColorTint(IJeiFluidIngredient ingredient) {
        FluidVariant fluidVariant = this.getFluidVariant(ingredient);
        int fluidColor = FluidVariantRendering.getColor((FluidVariant)fluidVariant);
        return fluidColor | 0xFF000000;
    }

    @Override
    public void getTooltip(ITooltipBuilder tooltip, IJeiFluidIngredient ingredient, TooltipFlag tooltipFlag) {
        FluidVariant fluidVariant = this.getFluidVariant(ingredient);
        List components = FluidVariantRendering.getTooltip((FluidVariant)fluidVariant, (TooltipFlag)tooltipFlag);
        tooltip.addAll(components);
    }

    private FluidVariant getFluidVariant(IJeiFluidIngredient ingredient) {
        Fluid fluid = ingredient.getFluid();
        CompoundTag tag = ingredient.getTag().orElse(null);
        return FluidVariant.of((Fluid)fluid, (CompoundTag)tag);
    }

    @Override
    public long getAmount(IJeiFluidIngredient ingredient) {
        return ingredient.getAmount();
    }

    @Override
    public Optional<CompoundTag> getTag(IJeiFluidIngredient ingredient) {
        return ingredient.getTag();
    }

    @Override
    public long bucketVolume() {
        return 81000L;
    }

    @Override
    public IJeiFluidIngredient create(Fluid fluid, long amount, @Nullable CompoundTag tag) {
        return new JeiFluidIngredient(fluid, amount, tag);
    }

    @Override
    public IJeiFluidIngredient create(Fluid fluid, long amount) {
        return new JeiFluidIngredient(fluid, amount);
    }

    @Override
    public IJeiFluidIngredient copy(IJeiFluidIngredient ingredient) {
        CompoundTag tag = ingredient.getTag().orElse(null);
        return new JeiFluidIngredient(ingredient.getFluid(), ingredient.getAmount(), tag);
    }

    @Override
    public IJeiFluidIngredient normalize(IJeiFluidIngredient ingredient) {
        if (ingredient.getAmount() == this.bucketVolume()) {
            return ingredient;
        }
        CompoundTag tag = ingredient.getTag().orElse(null);
        return new JeiFluidIngredient(ingredient.getFluid(), this.bucketVolume(), tag);
    }

    @Override
    public Optional<IJeiFluidIngredient> getContainedFluid(ITypedIngredient<?> ingredient) {
        return ingredient.getItemStack().map(ContainerItemContext::withConstant).map(c -> (Storage)c.find(FluidStorage.ITEM)).map(Storage::iterator).filter(Iterator::hasNext).map(Iterator::next).map(view -> {
            FluidVariant resource = (FluidVariant)view.getResource();
            return new JeiFluidIngredient(resource.getFluid(), this.bucketVolume(), resource.copyNbt());
        });
    }

    @Override
    public IJeiFluidIngredient copyWithAmount(IJeiFluidIngredient ingredient, long amount) {
        CompoundTag tag = ingredient.getTag().orElse(null);
        return new JeiFluidIngredient(ingredient.getFluid(), amount, tag);
    }

    private static class AllFluidNbt
    implements IIngredientSubtypeInterpreter<IJeiFluidIngredient> {
        public static final AllFluidNbt INSTANCE = new AllFluidNbt();

        private AllFluidNbt() {
        }

        @Override
        public String apply(IJeiFluidIngredient storage, UidContext context) {
            return storage.getTag().filter(tag -> !tag.m_128456_()).map(CompoundTag::toString).orElse("");
        }
    }
}

