/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.animatica.util;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.foundationgames.animatica.util.exception.InvalidPropertyException;
import io.github.foundationgames.animatica.util.exception.MissingPropertyException;
import io.github.foundationgames.animatica.util.exception.PropertyParseException;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntMaps;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Map;
import java.util.Properties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class Utilities {
    @NotNull
    public static ResourceLocation processPath(ResourceLocation fileRelativeTo, @NotNull ResourceLocation path) {
        if (path.m_135815_().startsWith("./")) {
            int lInd = fileRelativeTo.m_135815_().lastIndexOf("/");
            if (lInd > 0) {
                StringBuilder builder = new StringBuilder(fileRelativeTo.m_135815_());
                builder.replace(lInd, builder.length(), path.m_135815_().replaceFirst("\\./", "/"));
                return new ResourceLocation(fileRelativeTo.m_135827_(), builder.toString());
            }
        } else if (path.m_135815_().startsWith("~/")) {
            return new ResourceLocation(path.m_135827_(), path.m_135815_().replaceFirst("~/", "optifine/"));
        }
        return path;
    }

    @NotNull
    public static String get(ResourceLocation file, @NotNull Properties properties, String key) throws PropertyParseException {
        String p = properties.getProperty(key);
        if (p == null) {
            throw new MissingPropertyException(file, key);
        }
        return p;
    }

    @NotNull
    public static Properties getSubProperties(@NotNull Properties properties, String key) {
        Properties p = new Properties();
        String prefix = key + ".";
        for (String k : properties.stringPropertyNames()) {
            if (!k.startsWith(prefix)) continue;
            String newKey = k.replaceFirst(prefix, "");
            p.setProperty(newKey, properties.getProperty(k));
        }
        return p;
    }

    public static int getInt(ResourceLocation file, Properties properties, String key) throws PropertyParseException {
        int r;
        try {
            r = Integer.parseInt(Utilities.get(file, properties, key));
        }
        catch (NumberFormatException ignored) {
            throw new InvalidPropertyException(file, key, "integer (whole number)");
        }
        return r;
    }

    public static int getIntOr(ResourceLocation file, @NotNull Properties properties, String key, int defaultVal) throws PropertyParseException {
        int r;
        String p = properties.getProperty(key);
        if (p == null) {
            return defaultVal;
        }
        try {
            r = Integer.parseInt(p);
        }
        catch (NumberFormatException ignored) {
            throw new InvalidPropertyException(file, key, "integer");
        }
        return r;
    }

    public static boolean getBoolOr(ResourceLocation file, @NotNull Properties properties, String key, boolean defaultVal) throws PropertyParseException {
        String p = properties.getProperty(key);
        if (p == null) {
            return defaultVal;
        }
        if ("false".equals(p) || "true".equals(p)) {
            return "true".equals(p);
        }
        throw new InvalidPropertyException(file, key, "boolean (false/true)");
    }

    @NotNull
    public static @Unmodifiable Map<Integer, Integer> intToIntMap(@NotNull Properties in) {
        Int2IntOpenHashMap map = new Int2IntOpenHashMap();
        for (String k : in.stringPropertyNames()) {
            try {
                map.put(Integer.parseInt(k), Integer.parseInt(in.getProperty(k)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return Int2IntMaps.unmodifiable((Int2IntMap)map);
    }

    public static void copy(NativeImage src, int u, int v, int w, int h, NativeImage dest, int du, int dv) {
        for (int rx = 0; rx < w; ++rx) {
            for (int ry = 0; ry < h; ++ry) {
                int srcX = u + rx;
                int srcY = v + ry;
                int trgX = du + rx;
                int trgY = dv + ry;
                dest.m_84988_(trgX, trgY, src.m_84985_(srcX, srcY));
            }
        }
    }

    public static void blendCopy(NativeImage src, int u0, int v0, int u1, int v1, int w, int h, NativeImage dest, int du, int dv, float blend) {
        for (int rx = 0; rx < w; ++rx) {
            for (int ry = 0; ry < h; ++ry) {
                int srcX0 = u0 + rx;
                int srcY0 = v0 + ry;
                int srcX1 = u1 + rx;
                int srcY1 = v1 + ry;
                int trgX = du + rx;
                int trgY = dv + ry;
                dest.m_84988_(trgX, trgY, Utilities.lerpColor(src.m_85102_(), src.m_84985_(srcX0, srcY0), src.m_84985_(srcX1, srcY1), blend));
            }
        }
    }

    public static int lerpColor(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull NativeImage.Format format, int c1, int c2, float delta) {
        int a1 = c1 >> format.m_85172_() & 0xFF;
        int r1 = c1 >> format.m_166429_() & 0xFF;
        int g1 = c1 >> format.m_166430_() & 0xFF;
        int b1 = c1 >> format.m_166431_() & 0xFF;
        int a2 = c2 >> format.m_85172_() & 0xFF;
        int r2 = c2 >> format.m_166429_() & 0xFF;
        int g2 = c2 >> format.m_166430_() & 0xFF;
        int b2 = c2 >> format.m_166431_() & 0xFF;
        if (a1 == 0) {
            r1 = r2;
            g1 = g2;
            b1 = b2;
        } else if (a2 == 0) {
            r2 = r1;
            g2 = g1;
            b2 = b1;
        }
        int oa = Mth.m_269140_((float)delta, (int)a1, (int)a2);
        int or = Mth.m_269140_((float)delta, (int)r1, (int)r2);
        int og = Mth.m_269140_((float)delta, (int)g1, (int)g2);
        int ob = Mth.m_269140_((float)delta, (int)b1, (int)b2);
        return oa << format.m_85172_() | or << format.m_166429_() | og << format.m_166430_() | ob << format.m_166431_();
    }
}

