/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.animatica.animation;

import com.teampotato.potacore.iteration.MergedIterable;
import com.teampotato.potacore.iteration.MergedIterator;
import io.github.foundationgames.animatica.util.Utilities;
import io.github.foundationgames.animatica.util.exception.InvalidPropertyException;
import io.github.foundationgames.animatica.util.exception.PropertyParseException;
import java.util.Map;
import java.util.Properties;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record AnimationMeta(ResourceLocation source, ResourceLocation target, int targetX, int targetY, int width, int height, int defaultFrameDuration, boolean interpolate, int interpolationDelay, Map<Integer, Integer> frameMapping, Map<Integer, Integer> frameDurations) {
    @Contract(value="_, _ -> new")
    @NotNull
    public static AnimationMeta of(ResourceLocation file, Properties properties) throws PropertyParseException {
        ResourceLocation target;
        ResourceLocation source;
        try {
            source = Utilities.processPath(file, new ResourceLocation(Utilities.get(file, properties, "from")));
        }
        catch (ResourceLocationException ex) {
            throw new InvalidPropertyException(file, "from", "resource location");
        }
        try {
            target = Utilities.processPath(file, new ResourceLocation(Utilities.get(file, properties, "to")));
        }
        catch (ResourceLocationException ex) {
            throw new InvalidPropertyException(file, "to", "resource location");
        }
        return new AnimationMeta(source, target, Utilities.getInt(file, properties, "x"), Utilities.getInt(file, properties, "y"), Utilities.getInt(file, properties, "w"), Utilities.getInt(file, properties, "h"), Utilities.getIntOr(file, properties, "duration", 1), Utilities.getBoolOr(file, properties, "interpolate", false), Utilities.getIntOr(file, properties, "skip", 0), Utilities.intToIntMap(Utilities.getSubProperties(properties, "tile")), Utilities.intToIntMap(Utilities.getSubProperties(properties, "duration")));
    }

    public int getGreatestUsedFrame() {
        int greatestFrame = 0;
        MergedIterator mergedIterator = new MergedIterable(this.frameMapping.keySet(), this.frameDurations.keySet()).iterator();
        while (mergedIterator.hasNext()) {
            int frame = (Integer)mergedIterator.next();
            greatestFrame = Math.max(frame, greatestFrame);
        }
        return greatestFrame;
    }
}

