/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.animatica.animation;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.foundationgames.animatica.Animatica;
import io.github.foundationgames.animatica.animation.AnimatedTexture;
import io.github.foundationgames.animatica.animation.AnimationMeta;
import io.github.foundationgames.animatica.util.exception.PropertyParseException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.jetbrains.annotations.Nullable;

public final class AnimationLoader
implements ResourceManagerReloadListener {
    public static final String[] ANIM_PATHS = new String[]{"animatica/anim", "mcpatcher/anim", "optifine/anim"};
    public static final AnimationLoader INSTANCE = new AnimationLoader();
    private final Map<ResourceLocation, ResourceLocation> animationIds = new Object2ObjectOpenHashMap();
    private final Set<AnimatedTexture> animatedTextures = new ObjectOpenHashSet();

    private AnimationLoader() {
    }

    private static void findAllMCPAnimations(ResourceManager manager, BiConsumer<ResourceLocation, Resource> action) {
        for (String path : ANIM_PATHS) {
            manager.m_214159_(path, p -> p.m_135815_().endsWith(".properties")).forEach(action);
        }
    }

    @Nullable
    public ResourceLocation getAnimationId(ResourceLocation id) {
        return this.animationIds.get(id);
    }

    public void tickTextures() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(this::tickTextures);
        } else {
            for (AnimatedTexture texture : this.animatedTextures) {
                texture.tick();
            }
        }
    }

    public void m_6213_(ResourceManager manager) {
        this.animatedTextures.clear();
        this.animationIds.clear();
        if (!((Boolean)Animatica.ANIMATED_TEXTURES.get()).booleanValue()) {
            return;
        }
        Animatica.ALLOW_INVALID_ID_CHARS = true;
        Object2ObjectOpenHashMap animations = new Object2ObjectOpenHashMap();
        AnimationLoader.findAllMCPAnimations(manager, (id, resource) -> {
            try (InputStream resourceInputStream = resource.m_215507_();){
                Properties ppt = new Properties();
                ppt.load(resourceInputStream);
                AnimationMeta anim = AnimationMeta.of(id, ppt);
                ResourceLocation targetId = anim.target();
                if (!animations.containsKey((Object)targetId)) {
                    animations.put((Object)targetId, (Object)new ObjectArrayList());
                }
                ((List)animations.get((Object)targetId)).add(anim);
            }
            catch (PropertyParseException | IOException e) {
                Animatica.LOG.error(e.getMessage());
            }
        });
        for (ResourceLocation targetId : animations.keySet()) {
            AnimatedTexture.tryCreate(manager, targetId, (List)animations.get((Object)targetId)).ifPresent(tex -> {
                ResourceLocation animId = new ResourceLocation(targetId.m_135827_(), targetId.m_135815_() + "-anim");
                this.animationIds.put(targetId, animId);
                this.animatedTextures.add((AnimatedTexture)((Object)tex));
                tex.m_6479_(Minecraft.m_91087_().m_91097_(), manager, animId, (Executor)Minecraft.m_91087_());
            });
        }
        Animatica.ALLOW_INVALID_ID_CHARS = false;
    }
}

