/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.animatica.animation;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.foundationgames.animatica.Animatica;
import io.github.foundationgames.animatica.animation.AnimationMeta;
import io.github.foundationgames.animatica.util.Utilities;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class AnimatedTexture
extends DynamicTexture {
    public final Animation[] anims;
    private final NativeImage original;
    private int frame = 0;

    public static Optional<AnimatedTexture> tryCreate(ResourceManager resources, ResourceLocation targetTexId, List<AnimationMeta> anims) {
        Optional<AnimatedTexture> optional;
        block8: {
            InputStream targetTexResource = resources.m_215593_(targetTexId).m_215507_();
            try {
                optional = Optional.of(new AnimatedTexture(resources, anims, NativeImage.m_85058_((InputStream)targetTexResource)));
                if (targetTexResource == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (targetTexResource != null) {
                        try {
                            targetTexResource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Animatica.LOG.error((Object)e);
                    return Optional.empty();
                }
            }
            targetTexResource.close();
        }
        return optional;
    }

    public AnimatedTexture(ResourceManager resources, @NotNull List<AnimationMeta> metas, @NotNull NativeImage image) throws IOException {
        super(new NativeImage(image.m_85102_(), image.m_84982_(), image.m_85084_(), true));
        this.anims = new Animation[metas.size()];
        for (int i = 0; i < metas.size(); ++i) {
            this.anims[i] = new Animation(metas.get(i), resources);
        }
        this.original = image;
        this.updateAndDraw(this.m_117991_(), true);
        this.m_117985_();
    }

    public boolean canLoop() {
        for (Animation anim : this.anims) {
            if (anim.isOnFrameZero()) continue;
            return false;
        }
        return true;
    }

    public boolean updateAndDraw(NativeImage image, boolean force) {
        boolean changed = false;
        if (this.canLoop()) {
            if (this.frame > 0) {
                this.frame = 0;
            }
        } else if (this.frame <= 0) {
            changed = true;
        }
        for (Animation anim : this.anims) {
            if (!anim.isChanged()) continue;
            changed = true;
            break;
        }
        if (changed || force) {
            image.m_85054_(this.original);
            Animation[] animationArray = this.anims;
            int n = animationArray.length;
            for (int anim = 0; anim < n; ++anim) {
                Animation anim2 = animationArray[anim];
                Phase phase = anim2.getCurrentPhase();
                if (phase instanceof InterpolatedPhase) {
                    InterpolatedPhase iPhase = (InterpolatedPhase)phase;
                    Utilities.blendCopy(anim2.sourceTexture, 0, iPhase.prevV, 0, iPhase.v, anim2.width, anim2.height, image, anim2.targetX, anim2.targetY, iPhase.blend.getBlend(anim2.getPhaseFrame()));
                    continue;
                }
                Utilities.copy(anim2.sourceTexture, 0, phase.v, anim2.width, anim2.height, image, anim2.targetX, anim2.targetY);
            }
        }
        for (Animation anim : this.anims) {
            anim.advance();
        }
        ++this.frame;
        return changed;
    }

    public void tick() {
        if (this.updateAndDraw(this.m_117991_(), false)) {
            this.m_117985_();
        }
    }

    public void close() {
        for (Animation anim : this.anims) {
            anim.close();
        }
        this.original.close();
        super.close();
    }

    public static class Animation
    implements AutoCloseable {
        private final List<Phase> phases;
        public final NativeImage sourceTexture;
        public final int targetX;
        public final int targetY;
        public final int width;
        public final int height;
        private final int duration;
        private int frame = 0;
        private Phase currentPhase = null;
        private int phaseFrame = 0;
        private boolean changed = true;

        public Animation(@NotNull AnimationMeta meta, @NotNull ResourceManager resources) throws IOException {
            this.targetX = meta.targetX();
            this.targetY = meta.targetY();
            this.width = meta.width();
            this.height = meta.height();
            try (InputStream source = resources.m_215593_(meta.source()).m_215507_();){
                this.sourceTexture = NativeImage.m_85058_((InputStream)source);
            }
            ObjectArrayList phases = new ObjectArrayList();
            int duration = 0;
            int textureFrameCount = (int)Math.floor((float)this.sourceTexture.m_85084_() / (float)meta.height());
            int animFrameCount = Math.max(textureFrameCount, meta.getGreatestUsedFrame() + 1);
            ObjectArrayList frames = new ObjectArrayList();
            for (int f = 0; f < animFrameCount; ++f) {
                if (f >= textureFrameCount && !meta.frameMapping().containsKey(f)) continue;
                frames.add(new int[]{meta.frameMapping().getOrDefault(f, f), meta.frameDurations().getOrDefault(f, meta.defaultFrameDuration())});
            }
            for (int i = 0; i < frames.size(); ++i) {
                int[] frame = (int[])frames.get(i);
                int fMap = frame[0];
                int fDuration = frame[1];
                int v = this.getVForFrame(fMap, textureFrameCount);
                int nextV = this.getVForFrame(((int[])frames.get(Math.floorMod(i + 1, frames.size())))[0], textureFrameCount);
                if (meta.interpolate()) {
                    if (meta.interpolationDelay() > 0) {
                        phases.add((Object)new Phase(meta.interpolationDelay(), v));
                        duration += meta.interpolationDelay();
                    }
                    int interpolatedDuration = fDuration - meta.interpolationDelay();
                    phases.add((Object)new InterpolatedPhase(interpolatedDuration, v, nextV, phaseFrame -> (float)phaseFrame / (float)interpolatedDuration));
                    duration += interpolatedDuration;
                    continue;
                }
                phases.add((Object)new Phase(fDuration, v));
                duration += fDuration;
            }
            this.duration = duration;
            this.phases = ObjectLists.unmodifiable((ObjectList)phases);
            this.updateCurrentPhase();
        }

        public void updateCurrentPhase() {
            this.changed = false;
            int progress = this.frame;
            for (Phase phase : this.phases) {
                if ((progress -= phase.duration) >= 0) continue;
                if (this.currentPhase != phase) {
                    this.changed = true;
                }
                if (phase instanceof InterpolatedPhase) {
                    InterpolatedPhase iPhase = (InterpolatedPhase)phase;
                    this.changed = iPhase.hasChangingV();
                }
                this.currentPhase = phase;
                this.phaseFrame = phase.duration + progress;
                return;
            }
        }

        public Phase getCurrentPhase() {
            return this.currentPhase;
        }

        public int getPhaseFrame() {
            return this.phaseFrame;
        }

        public boolean isOnFrameZero() {
            return this.frame <= 0;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public void advance() {
            ++this.frame;
            if (this.frame >= this.duration) {
                this.frame = 0;
            }
            this.updateCurrentPhase();
        }

        @Override
        public void close() {
            this.sourceTexture.close();
        }

        private int getVForFrame(int frame, int textureFrameCount) {
            return Mth.m_14045_((int)(frame * this.height), (int)0, (int)((textureFrameCount - 1) * this.height));
        }
    }

    public static class Phase {
        public final int duration;
        public final int v;

        public Phase(int duration, int v) {
            this.duration = duration;
            this.v = v;
        }

        public String toString() {
            return "Animation Bakery Phase { v: " + this.v + " }";
        }
    }

    public static class InterpolatedPhase
    extends Phase {
        public final int prevV;
        public final BlendInterpolator blend;

        public InterpolatedPhase(int duration, int v1, int v2, BlendInterpolator blend) {
            super(duration, v2);
            this.prevV = v1;
            this.blend = blend;
        }

        public boolean hasChangingV() {
            return this.prevV != this.v;
        }
    }

    @FunctionalInterface
    public static interface BlendInterpolator {
        public float getBlend(int var1);
    }
}

