/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import me.pepperbell.continuity.client.ContinuityClient;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public final class EmissiveSuffixLoader {
    public static final ResourceLocation LOCATION = new ResourceLocation("optifine/emissive.properties");
    private static String emissiveSuffix;

    @Nullable
    public static String getEmissiveSuffix() {
        return emissiveSuffix;
    }

    public static void load(ResourceManager manager) {
        emissiveSuffix = null;
        Optional optionalResource = manager.m_213713_(LOCATION);
        if (optionalResource.isPresent()) {
            Resource resource = (Resource)optionalResource.get();
            try (InputStream inputStream = resource.m_215507_();){
                Properties properties = new Properties();
                properties.load(inputStream);
                emissiveSuffix = properties.getProperty("suffix.emissive");
            }
            catch (IOException e) {
                ContinuityClient.LOGGER.error("Failed to load emissive suffix from file '" + LOCATION + "'", (Throwable)e);
            }
        }
    }
}

