/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.properties.PropertiesParsingHelper;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public final class CustomBlockLayers {
    public static final ResourceLocation LOCATION = new ResourceLocation("optifine/block.properties");
    private static final Predicate<BlockState>[] EMPTY_LAYER_PREDICATES = new Predicate[BlockLayer.VALUES.length];
    private static final Predicate<BlockState>[] LAYER_PREDICATES = new Predicate[BlockLayer.VALUES.length];
    private static boolean empty;
    private static boolean disableSolidCheck;

    public static boolean isEmpty() {
        return empty;
    }

    @Nullable
    public static RenderType getLayer(BlockState state) {
        if (!disableSolidCheck && state.m_60804_((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_)) {
            return null;
        }
        for (int i = 0; i < BlockLayer.VALUES.length; ++i) {
            Predicate<BlockState> predicate = LAYER_PREDICATES[i];
            if (predicate == null || !predicate.test(state)) continue;
            return BlockLayer.VALUES[i].getLayer();
        }
        return null;
    }

    private static void reload(ResourceManager manager) {
        empty = true;
        System.arraycopy(EMPTY_LAYER_PREDICATES, 0, LAYER_PREDICATES, 0, EMPTY_LAYER_PREDICATES.length);
        disableSolidCheck = false;
        Optional optionalResource = manager.m_213713_(LOCATION);
        if (optionalResource.isPresent()) {
            Resource resource = (Resource)optionalResource.get();
            try (InputStream inputStream = resource.m_215507_();){
                Properties properties = new Properties();
                properties.load(inputStream);
                CustomBlockLayers.reload(properties, LOCATION, resource.m_215506_());
            }
            catch (IOException e) {
                ContinuityClient.LOGGER.error("Failed to load custom block layers from file '" + LOCATION + "' from pack '" + resource.m_215506_() + "'", (Throwable)e);
            }
        }
    }

    private static void reload(Properties properties, ResourceLocation fileLocation, String packName) {
        for (BlockLayer blockLayer : BlockLayer.VALUES) {
            String propertyKey = "layer." + blockLayer.getKey();
            Predicate<BlockState> predicate = PropertiesParsingHelper.parseBlockStates(properties, propertyKey, fileLocation, packName);
            if (predicate == null || predicate == PropertiesParsingHelper.EMPTY_BLOCK_STATE_PREDICATE) continue;
            CustomBlockLayers.LAYER_PREDICATES[blockLayer.ordinal()] = predicate;
            empty = false;
        }
        String disableSolidCheckStr = properties.getProperty("disableSolidCheck");
        if (disableSolidCheckStr != null) {
            disableSolidCheck = Boolean.parseBoolean(disableSolidCheckStr.trim());
        }
    }

    private static enum BlockLayer {
        SOLID(RenderType.m_110451_()),
        CUTOUT(RenderType.m_110463_()),
        CUTOUT_MIPPED(RenderType.m_110457_()),
        TRANSLUCENT(RenderType.m_110466_());

        public static final BlockLayer[] VALUES;
        private final RenderType layer;
        private final String key;

        private BlockLayer(RenderType layer) {
            this.layer = layer;
            this.key = this.name().toLowerCase(Locale.ROOT);
        }

        public RenderType getLayer() {
            return this.layer;
        }

        public String getKey() {
            return this.key;
        }

        static {
            VALUES = BlockLayer.values();
        }
    }

    public static class ReloadListener
    implements SimpleSynchronousResourceReloadListener {
        public static final ResourceLocation ID = ContinuityClient.asId("custom_block_layers");
        private static final ReloadListener INSTANCE = new ReloadListener();

        public static void init() {
            ResourceManagerHelper.get((PackType)PackType.CLIENT_RESOURCES).registerReloadListener((IdentifiableResourceReloadListener)INSTANCE);
        }

        public void m_6213_(ResourceManager manager) {
            CustomBlockLayers.reload(manager);
        }

        public ResourceLocation getFabricId() {
            return ID;
        }
    }
}

