/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.util.Properties;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.processor.OrientationMode;
import me.pepperbell.continuity.client.properties.OrientedConnectingCtmProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class CompactConnectingCtmProperties
extends OrientedConnectingCtmProperties {
    @Nullable
    protected Int2IntMap tileReplacementMap;

    public CompactConnectingCtmProperties(Properties properties, ResourceLocation resourceId, PackResources pack, int packPriority, ResourceManager resourceManager, String method, OrientationMode defaultOrientationMode) {
        super(properties, resourceId, pack, packPriority, resourceManager, method, defaultOrientationMode);
    }

    public CompactConnectingCtmProperties(Properties properties, ResourceLocation resourceId, PackResources pack, int packPriority, ResourceManager resourceManager, String method) {
        this(properties, resourceId, pack, packPriority, resourceManager, method, OrientationMode.TEXTURE);
    }

    @Override
    public void init() {
        super.init();
        this.parseTileReplacements();
    }

    protected void parseTileReplacements() {
        for (String key : this.properties.stringPropertyNames()) {
            int value;
            int index;
            if (!key.startsWith("ctm.")) continue;
            String indexStr = key.substring(4);
            try {
                index = Integer.parseInt(indexStr);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (index < 0) continue;
            String valueStr = this.properties.getProperty(key);
            try {
                value = Integer.parseInt(valueStr);
            }
            catch (NumberFormatException e) {
                ContinuityClient.LOGGER.warn("Invalid '" + key + "' value '" + valueStr + "' in file '" + this.resourceId + "' in pack '" + this.packName + "'");
                continue;
            }
            if (value < 0) {
                ContinuityClient.LOGGER.warn("Invalid '" + key + "' value '" + valueStr + "' in file '" + this.resourceId + "' in pack '" + this.packName + "'");
                continue;
            }
            if (this.tileReplacementMap == null) {
                this.tileReplacementMap = new Int2IntArrayMap();
            }
            this.tileReplacementMap.put(index, value);
        }
    }

    @Nullable
    public Int2IntMap getTileReplacementMap() {
        return this.tileReplacementMap;
    }
}

