/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor.overlay;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import me.pepperbell.continuity.client.processor.overlay.OverlayProcessingPredicate;
import me.pepperbell.continuity.client.processor.simple.SimpleQuadProcessor;
import me.pepperbell.continuity.client.processor.simple.SpriteProvider;
import me.pepperbell.continuity.client.properties.BaseCtmProperties;
import me.pepperbell.continuity.client.properties.overlay.OverlayPropertiesSection;
import me.pepperbell.continuity.client.util.QuadUtil;
import me.pepperbell.continuity.client.util.RenderUtil;
import me.pepperbell.continuity.client.util.TextureUtil;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SimpleOverlayQuadProcessor
extends SimpleQuadProcessor {
    protected int tintIndex;
    @Nullable
    protected BlockState tintBlock;
    protected RenderMaterial material;

    public SimpleOverlayQuadProcessor(SpriteProvider spriteProvider, ProcessingPredicate processingPredicate, int tintIndex, @Nullable BlockState tintBlock, BlendMode layer) {
        super(spriteProvider, processingPredicate);
        this.tintIndex = tintIndex;
        this.tintBlock = tintBlock;
        this.material = RenderUtil.findOverlayMaterial(layer, this.tintBlock);
    }

    @Override
    public QuadProcessor.ProcessingResult processQuad(MutableQuadView quad, TextureAtlasSprite sprite, BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, int pass, QuadProcessor.ProcessingContext context) {
        TextureAtlasSprite newSprite;
        if (this.processingPredicate.shouldProcessQuad((QuadView)quad, sprite, blockView, state, pos, context) && (newSprite = this.spriteProvider.getSprite((QuadView)quad, sprite, blockView, state, pos, randomSupplier, context)) != null && !TextureUtil.isMissingSprite(newSprite)) {
            OverlayEmitter emitter = context.getData(ProcessingDataKeys.SIMPLE_OVERLAY_EMITTER_POOL_KEY).get();
            emitter.prepare(quad.lightFace(), newSprite, RenderUtil.getTintColor(this.tintBlock, blockView, pos, this.tintIndex), this.material);
            context.addEmitterConsumer(emitter);
        }
        return QuadProcessor.ProcessingResult.NEXT_PROCESSOR;
    }

    public static class OverlayEmitterPool {
        protected final List<OverlayEmitter> list = new ObjectArrayList();
        protected int nextIndex = 0;

        public OverlayEmitter get() {
            if (this.nextIndex >= this.list.size()) {
                this.list.add(new OverlayEmitter());
            }
            OverlayEmitter emitter = this.list.get(this.nextIndex);
            ++this.nextIndex;
            return emitter;
        }

        public void reset() {
            this.nextIndex = 0;
        }
    }

    public static class OverlayEmitter
    implements Consumer<QuadEmitter> {
        protected Direction face;
        protected TextureAtlasSprite sprite;
        protected int color;
        protected RenderMaterial material;

        @Override
        public void accept(QuadEmitter emitter) {
            QuadUtil.emitOverlayQuad(emitter, this.face, this.sprite, this.color, this.material);
        }

        public void prepare(Direction face, TextureAtlasSprite sprite, int color, RenderMaterial material) {
            this.face = face;
            this.sprite = sprite;
            this.color = color;
            this.material = material;
        }
    }

    public static class Factory<T extends BaseCtmProperties>
    extends SimpleQuadProcessor.Factory<T> {
        public Factory(SpriteProvider.Factory<? super T> spriteProviderFactory) {
            super(spriteProviderFactory);
        }

        @Override
        public QuadProcessor createProcessor(T properties, TextureAtlasSprite[] sprites) {
            OverlayPropertiesSection overlaySection = ((OverlayPropertiesSection.Provider)properties).getOverlayPropertiesSection();
            return new SimpleOverlayQuadProcessor(this.spriteProviderFactory.createSpriteProvider(sprites, properties), OverlayProcessingPredicate.fromProperties(properties), overlaySection.getTintIndex(), overlaySection.getTintBlock(), overlaySection.getLayer());
        }

        @Override
        public boolean supportsNullSprites(T properties) {
            return false;
        }
    }
}

