/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor;

import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractQuadProcessor
implements QuadProcessor {
    protected TextureAtlasSprite[] sprites;
    protected ProcessingPredicate processingPredicate;

    public AbstractQuadProcessor(TextureAtlasSprite[] sprites, ProcessingPredicate processingPredicate) {
        this.sprites = sprites;
        this.processingPredicate = processingPredicate;
    }

    @Override
    public QuadProcessor.ProcessingResult processQuad(MutableQuadView quad, TextureAtlasSprite sprite, BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, int pass, QuadProcessor.ProcessingContext context) {
        if (!this.processingPredicate.shouldProcessQuad((QuadView)quad, sprite, blockView, state, pos, context)) {
            return QuadProcessor.ProcessingResult.NEXT_PROCESSOR;
        }
        return this.processQuadInner(quad, sprite, blockView, state, pos, randomSupplier, pass, context);
    }

    public abstract QuadProcessor.ProcessingResult processQuadInner(MutableQuadView var1, TextureAtlasSprite var2, BlockAndTintGetter var3, BlockState var4, BlockPos var5, Supplier<RandomSource> var6, int var7, QuadProcessor.ProcessingContext var8);
}

