/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.model;

import java.util.function.Function;
import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.config.ContinuityConfig;
import me.pepperbell.continuity.client.model.ModelObjectsContainer;
import me.pepperbell.continuity.client.model.QuadProcessors;
import me.pepperbell.continuity.client.util.RenderUtil;
import me.pepperbell.continuity.impl.client.ProcessingContextImpl;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public class CtmBakedModel
extends ForwardingBakedModel {
    public static final int PASSES = 4;
    protected final BlockState defaultState;
    protected volatile Function<TextureAtlasSprite, QuadProcessors.Slice> defaultSliceFunc;

    public CtmBakedModel(BakedModel wrapped, BlockState defaultState) {
        this.wrapped = wrapped;
        this.defaultState = defaultState;
    }

    public void emitBlockQuads(BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, RenderContext context) {
        if (!((Boolean)ContinuityConfig.INSTANCE.connectedTextures.get()).booleanValue()) {
            super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
            return;
        }
        ModelObjectsContainer container = ModelObjectsContainer.get();
        if (!container.featureStates.getConnectedTexturesState().isEnabled()) {
            super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
            return;
        }
        CtmQuadTransform quadTransform = container.ctmQuadTransform;
        if (quadTransform.isActive()) {
            super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
            return;
        }
        quadTransform.prepare(blockView, state, pos, randomSupplier, context, (Boolean)ContinuityConfig.INSTANCE.useManualCulling.get(), this.getSliceFunc(state));
        context.pushTransform((RenderContext.QuadTransform)quadTransform);
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
        quadTransform.processingContext.outputTo(context.getEmitter());
        quadTransform.reset();
    }

    public boolean isVanillaAdapter() {
        if (!((Boolean)ContinuityConfig.INSTANCE.connectedTextures.get()).booleanValue()) {
            return super.isVanillaAdapter();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Function<TextureAtlasSprite, QuadProcessors.Slice> getSliceFunc(BlockState state) {
        if (state == this.defaultState) {
            Function<TextureAtlasSprite, QuadProcessors.Slice> sliceFunc = this.defaultSliceFunc;
            if (sliceFunc == null) {
                CtmBakedModel ctmBakedModel = this;
                synchronized (ctmBakedModel) {
                    sliceFunc = this.defaultSliceFunc;
                    if (sliceFunc == null) {
                        this.defaultSliceFunc = sliceFunc = QuadProcessors.getCache(state);
                    }
                }
            }
            return sliceFunc;
        }
        return QuadProcessors.getCache(state);
    }

    protected static class CtmQuadTransform
    implements RenderContext.QuadTransform {
        protected final ProcessingContextImpl processingContext = new ProcessingContextImpl();
        protected BlockAndTintGetter blockView;
        protected BlockState state;
        protected BlockPos pos;
        protected Supplier<RandomSource> randomSupplier;
        protected RenderContext renderContext;
        protected boolean useManualCulling;
        protected Function<TextureAtlasSprite, QuadProcessors.Slice> sliceFunc;
        protected boolean active;

        protected CtmQuadTransform() {
        }

        public boolean transform(MutableQuadView quad) {
            if (this.useManualCulling && this.renderContext.isFaceCulled(quad.cullFace())) {
                return false;
            }
            for (int pass = 0; pass < 4; ++pass) {
                Boolean result = this.transformOnce(quad, pass);
                if (result == null) continue;
                return result;
            }
            return true;
        }

        protected Boolean transformOnce(MutableQuadView quad, int pass) {
            QuadProcessor[] processors;
            TextureAtlasSprite sprite = RenderUtil.getSpriteFinder().find((QuadView)quad);
            QuadProcessors.Slice slice = this.sliceFunc.apply(sprite);
            for (QuadProcessor processor : processors = pass == 0 ? slice.processors() : slice.multipassProcessors()) {
                QuadProcessor.ProcessingResult result = processor.processQuad(quad, sprite, this.blockView, this.state, this.pos, this.randomSupplier, pass, this.processingContext);
                if (result == QuadProcessor.ProcessingResult.NEXT_PROCESSOR) continue;
                if (result == QuadProcessor.ProcessingResult.NEXT_PASS) {
                    return null;
                }
                if (result == QuadProcessor.ProcessingResult.STOP) {
                    return true;
                }
                if (result != QuadProcessor.ProcessingResult.DISCARD) continue;
                return false;
            }
            return true;
        }

        public boolean isActive() {
            return this.active;
        }

        public void prepare(BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, RenderContext renderContext, boolean useManualCulling, Function<TextureAtlasSprite, QuadProcessors.Slice> sliceFunc) {
            this.blockView = blockView;
            this.state = state;
            this.pos = pos;
            this.randomSupplier = randomSupplier;
            this.renderContext = renderContext;
            this.useManualCulling = useManualCulling;
            this.sliceFunc = sliceFunc;
            this.active = true;
            this.processingContext.prepare();
        }

        public void reset() {
            this.blockView = null;
            this.state = null;
            this.pos = null;
            this.randomSupplier = null;
            this.renderContext = null;
            this.useManualCulling = false;
            this.sliceFunc = null;
            this.active = false;
            this.processingContext.reset();
        }
    }
}

