/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.mixin;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import me.pepperbell.continuity.client.resource.AtlasLoaderInitContext;
import me.pepperbell.continuity.client.resource.AtlasLoaderLoadContext;
import me.pepperbell.continuity.client.resource.EmissiveSuffixLoader;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.SingleFile;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={SpriteResourceLoader.class})
abstract class AtlasLoaderMixin {
    AtlasLoaderMixin() {
    }

    @ModifyVariable(method={"<init>(Ljava/util/List;)V"}, at=@At(value="LOAD", ordinal=0), argsOnly=true, ordinal=0)
    private List<SpriteSource> continuity$modifySources(List<SpriteSource> sources) {
        Set<ResourceLocation> extraIds;
        AtlasLoaderInitContext context = AtlasLoaderInitContext.THREAD_LOCAL.get();
        if (context != null && (extraIds = context.getExtraIds()) != null && !extraIds.isEmpty()) {
            ObjectArrayList extraSources = new ObjectArrayList();
            for (ResourceLocation extraId : extraIds) {
                extraSources.add(new SingleFile(extraId, Optional.empty()));
            }
            if (sources instanceof ArrayList) {
                sources.addAll(0, (Collection<SpriteSource>)extraSources);
            } else {
                ArrayList<SpriteSource> mutableSources = new ArrayList<SpriteSource>((Collection<SpriteSource>)extraSources);
                mutableSources.addAll(sources);
                return mutableSources;
            }
        }
        return sources;
    }

    @Inject(method={"loadSources(Lnet/minecraft/resource/ResourceManager;)Ljava/util/List;"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableList;builder()Lcom/google/common/collect/ImmutableList$Builder;", remap=false)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void continuity$afterLoadSources(ResourceManager resourceManager, CallbackInfoReturnable<List<Supplier<SpriteContents>>> cir, Map<ResourceLocation, SpriteSource.SpriteSupplier> suppliers) {
        String emissiveSuffix;
        AtlasLoaderLoadContext context = AtlasLoaderLoadContext.THREAD_LOCAL.get();
        if (context != null && (emissiveSuffix = EmissiveSuffixLoader.getEmissiveSuffix()) != null) {
            Object2ObjectOpenHashMap emissiveSuppliers = new Object2ObjectOpenHashMap();
            Object2ObjectOpenHashMap emissiveIdMap = new Object2ObjectOpenHashMap();
            suppliers.forEach((arg_0, arg_1) -> AtlasLoaderMixin.lambda$continuity$afterLoadSources$1(emissiveSuffix, suppliers, resourceManager, (Map)emissiveSuppliers, (Map)emissiveIdMap, arg_0, arg_1));
            suppliers.putAll((Map<ResourceLocation, SpriteSource.SpriteSupplier>)emissiveSuppliers);
            if (!emissiveIdMap.isEmpty()) {
                context.setEmissiveIdMap((Map<ResourceLocation, ResourceLocation>)emissiveIdMap);
            }
        }
    }

    private static /* synthetic */ void lambda$continuity$afterLoadSources$1(String emissiveSuffix, Map suppliers, ResourceManager resourceManager, Map emissiveSuppliers, Map emissiveIdMap, ResourceLocation id, SpriteSource.SpriteSupplier supplier) {
        if (!id.m_135815_().endsWith(emissiveSuffix)) {
            ResourceLocation emissiveId = new ResourceLocation(id.m_135827_(), id.m_135815_() + emissiveSuffix);
            if (!suppliers.containsKey(emissiveId)) {
                ResourceLocation emissiveLocation = emissiveId.m_247449_("textures/" + emissiveId.m_135815_() + ".png");
                Optional optionalResource = resourceManager.m_213713_(emissiveLocation);
                if (optionalResource.isPresent()) {
                    Resource resource = (Resource)optionalResource.get();
                    emissiveSuppliers.put(emissiveId, () -> SpriteLoader.m_245083_((ResourceLocation)emissiveId, (Resource)resource));
                    emissiveIdMap.put(id, emissiveId);
                }
            } else {
                emissiveIdMap.put(id, emissiveId);
            }
        }
    }
}

