/*
 * Decompiled with CFR 0.152.
 */
package com.teampotato.potacore.iteration;

import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface CloseableIterator<T>
extends Iterator<T>,
AutoCloseable {
    public static final Logger LOGGER = LogManager.getLogger(CloseableIterator.class);

    public static void close(Iterator<?> iterator) {
        if (iterator == null) {
            return;
        }
        try {
            if (iterator instanceof AutoCloseable) {
                ((AutoCloseable)((Object)iterator)).close();
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Error occurs during CloseableIterator closing", (Throwable)exception);
        }
    }

    public static void close(Iterator<?> ... iterators) {
        if (iterators == null) {
            return;
        }
        for (Iterator<?> iterator : iterators) {
            CloseableIterator.close(iterator);
        }
    }
}

