/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.function.Predicate;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.properties.BaseCtmProperties;
import me.pepperbell.continuity.client.util.SpriteCalculator;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class BasicConnectingCtmProperties
extends BaseCtmProperties {
    protected ConnectionPredicate connectionPredicate;
    protected Predicate<class_6862<class_2248>> tagPredicate;

    public BasicConnectingCtmProperties(Properties properties, class_2960 resourceId, class_3262 pack, int packPriority, class_3300 resourceManager, String method) {
        super(properties, resourceId, pack, packPriority, resourceManager, method);
    }

    @Override
    public void init() {
        super.init();
        this.parseConnect();
        this.parseTags();
        this.detectConnect();
        this.validateConnect();
    }

    protected void parseConnect() {
        String connectStr = this.properties.getProperty("connect");
        if (connectStr == null) {
            return;
        }
        try {
            this.connectionPredicate = ConnectionType.valueOf(connectStr.trim().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void parseTags() {
        String tagsStr = this.properties.getProperty("tags");
        if (tagsStr == null) {
            return;
        }
        String[] tagStrs = tagsStr.trim().split("[ ,]");
        if (tagStrs.length != 0) {
            final ObjectOpenHashSet tagHolderSet = new ObjectOpenHashSet();
            for (int i = 0; i < tagStrs.length; ++i) {
                String tagStr = tagStrs[i];
                if (tagStr.isEmpty()) continue;
                class_2960 tagId = new class_2960(tagStr);
                class_6862 key = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)tagId);
                tagHolderSet.add((Object)key);
            }
            this.tagPredicate = new Predicate<class_6862<class_2248>>(){

                @Override
                public boolean test(class_6862<class_2248> blockTagKey) {
                    return tagHolderSet.contains(blockTagKey);
                }
            };
        }
    }

    public Predicate<class_6862<class_2248>> getTagPredicate() {
        return this.tagPredicate;
    }

    protected void detectConnect() {
        if (this.connectionPredicate == null) {
            if (this.matchBlocksPredicate != null) {
                this.connectionPredicate = ConnectionType.BLOCK;
            } else if (this.matchTilesSet != null) {
                this.connectionPredicate = ConnectionType.TILE;
            }
        }
    }

    protected void validateConnect() {
        if (this.connectionPredicate == null) {
            ContinuityClient.LOGGER.error("No valid connection type provided in file '" + this.resourceId + "' in pack '" + this.packId + "'");
            this.valid = false;
        }
    }

    public ConnectionPredicate getConnectionPredicate() {
        return this.connectionPredicate;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ConnectionType implements ConnectionPredicate
    {
        VINE{

            @Override
            public boolean shouldConnect(class_1920 blockView, class_2680 appearanceState, class_2680 state, class_2338 pos, class_2680 otherAppearanceState, class_2680 otherState, class_2338 otherPos, class_2350 face, class_1058 quadSprite) {
                return otherAppearanceState.method_26204().method_9573(otherAppearanceState).equals(class_2498.field_23083);
            }
        }
        ,
        METAL{

            @Override
            public boolean shouldConnect(class_1920 blockView, class_2680 appearanceState, class_2680 state, class_2338 pos, class_2680 otherAppearanceState, class_2680 otherState, class_2338 otherPos, class_2350 face, class_1058 quadSprite) {
                return otherAppearanceState.method_26204().method_9573(otherAppearanceState).equals(class_2498.field_11533);
            }
        }
        ,
        PLANTS{

            @Override
            public boolean shouldConnect(class_1920 blockView, class_2680 appearanceState, class_2680 state, class_2338 pos, class_2680 otherAppearanceState, class_2680 otherState, class_2338 otherPos, class_2350 face, class_1058 quadSprite) {
                return otherAppearanceState.method_26204().method_9573(otherAppearanceState).equals(class_2498.field_11535) && otherAppearanceState.method_26204().method_36555() == 0.0f;
            }
        }
        ,
        LEAVES{

            @Override
            public boolean shouldConnect(class_1920 blockView, class_2680 appearanceState, class_2680 state, class_2338 pos, class_2680 otherAppearanceState, class_2680 otherState, class_2338 otherPos, class_2350 face, class_1058 quadSprite) {
                return otherAppearanceState.method_26164(class_3481.field_15503);
            }
        }
        ,
        SOIL{

            @Override
            public boolean shouldConnect(class_1920 blockView, class_2680 appearanceState, class_2680 state, class_2338 pos, class_2680 otherAppearanceState, class_2680 otherState, class_2338 otherPos, class_2350 face, class_1058 quadSprite) {
                class_2498 soundGroup = otherAppearanceState.method_26204().method_9573(otherAppearanceState);
                return soundGroup.equals(class_2498.field_11529) || soundGroup.equals(class_2498.field_11526) || soundGroup.equals(class_2498.field_11535);
            }
        }
        ,
        WOOD{

            @Override
            public boolean shouldConnect(class_1920 blockView, class_2680 appearanceState, class_2680 state, class_2338 pos, class_2680 otherAppearanceState, class_2680 otherState, class_2338 otherPos, class_2350 face, class_1058 quadSprite) {
                return otherAppearanceState.method_26204().method_9573(otherAppearanceState).equals(class_2498.field_11547);
            }
        }
        ,
        STONE{

            @Override
            public boolean shouldConnect(class_1920 blockView, class_2680 appearanceState, class_2680 state, class_2338 pos, class_2680 otherAppearanceState, class_2680 otherState, class_2338 otherPos, class_2350 face, class_1058 quadSprite) {
                return otherAppearanceState.method_26204().method_9573(otherAppearanceState).equals(class_2498.field_11544) && !otherAppearanceState.method_26215();
            }
        }
        ,
        BLOCK{

            @Override
            public boolean shouldConnect(class_1920 blockView, class_2680 appearanceState, class_2680 state, class_2338 pos, class_2680 otherAppearanceState, class_2680 otherState, class_2338 otherPos, class_2350 face, class_1058 quadSprite) {
                return appearanceState.method_26204() == otherAppearanceState.method_26204();
            }
        }
        ,
        TILE{

            @Override
            public boolean shouldConnect(class_1920 blockView, class_2680 appearanceState, class_2680 state, class_2338 pos, class_2680 otherAppearanceState, class_2680 otherState, class_2338 otherPos, class_2350 face, class_1058 quadSprite) {
                if (appearanceState == otherAppearanceState) {
                    return true;
                }
                return quadSprite == SpriteCalculator.getSprite(otherAppearanceState, face);
            }
        }
        ,
        STATE{

            @Override
            public boolean shouldConnect(class_1920 blockView, class_2680 appearanceState, class_2680 state, class_2338 pos, class_2680 otherAppearanceState, class_2680 otherState, class_2338 otherPos, class_2350 face, class_1058 quadSprite) {
                return appearanceState == otherAppearanceState;
            }
        };

    }
}

