/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.bettergrass;

import dev.ultimatchamp.bettergrass.SpriteCalculator;
import dev.ultimatchamp.bettergrass.config.ForgeBetterGrassConfig;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class ForgeBetterGrassBakedModel
extends ForwardingBakedModel {
    public ForgeBetterGrassBakedModel(BakedModel baseModel) {
        this.wrapped = baseModel;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, RenderContext context) {
        AtomicInteger counter = new AtomicInteger();
        context.pushTransform(quad -> {
            if (ForgeBetterGrassConfig.instance().betterGrassMode.equals((Object)BetterGrassMode.OFF)) {
                return true;
            }
            if (ForgeBetterGrassConfig.instance().betterGrassMode.equals((Object)BetterGrassMode.FAST)) {
                if (quad.nominalFace().m_122434_() != Direction.Axis.Y && counter.get() <= 9) {
                    if (ForgeBetterGrassBakedModel.isSnowy(blockView, pos)) {
                        ForgeBetterGrassBakedModel.spriteBake(quad, blockView.m_8055_(pos.m_7494_()), randomSupplier);
                    } else {
                        ForgeBetterGrassBakedModel.spriteBake(quad, blockView.m_8055_(pos), randomSupplier);
                    }
                    counter.addAndGet(1);
                    return true;
                }
            } else if (ForgeBetterGrassConfig.instance().betterGrassMode.equals((Object)BetterGrassMode.FANCY)) {
                Direction face;
                if (quad.nominalFace().m_122434_() != Direction.Axis.Y && counter.get() <= 9 && ForgeBetterGrassBakedModel.canFullyConnect(blockView, state, pos, face = quad.nominalFace())) {
                    if (ForgeBetterGrassBakedModel.isSnowy(blockView, pos)) {
                        ForgeBetterGrassBakedModel.spriteBake(quad, blockView.m_8055_(pos.m_7494_()), randomSupplier);
                    } else {
                        ForgeBetterGrassBakedModel.spriteBake(quad, state, randomSupplier);
                    }
                }
                counter.addAndGet(1);
                return true;
            }
            counter.addAndGet(1);
            return true;
        });
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
    }

    private static boolean canFullyConnect(BlockAndTintGetter world, BlockState self, BlockPos selfPos, Direction direction) {
        return ForgeBetterGrassBakedModel.canConnect(world, self, selfPos, selfPos.m_121945_(direction).m_7495_());
    }

    private static boolean canConnect(BlockAndTintGetter world, BlockState self, BlockPos selfPos, BlockPos adjacentPos) {
        BlockState adjacent = world.m_8055_(adjacentPos);
        BlockPos upPos = adjacentPos.m_7494_();
        BlockState up = world.m_8055_(upPos);
        return ForgeBetterGrassBakedModel.canConnect(self, adjacent) && (up.m_60795_() || ForgeBetterGrassBakedModel.isSnowy(world, selfPos) || !up.m_60783_((BlockGetter)world, upPos, Direction.DOWN));
    }

    private static boolean canConnect(BlockState self, BlockState adjacent) {
        return self == adjacent;
    }

    private static boolean isSnowy(BlockAndTintGetter world, BlockPos selfPos) {
        return String.valueOf(world.m_8055_(selfPos)).contains("block}[snowy=true]");
    }

    private static boolean spriteBake(MutableQuadView quad, BlockState state, Supplier<RandomSource> randomSupplier) {
        TextureAtlasSprite sprite = SpriteCalculator.calculateSprite(state, Direction.UP, randomSupplier);
        if (sprite != null && !String.valueOf(sprite).contains("missingno")) {
            quad.spriteBake(0, sprite, 4);
            return true;
        }
        return false;
    }

    public static enum BetterGrassMode {
        OFF,
        FAST,
        FANCY;

    }
}

