/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.impl;

import com.google.common.collect.ImmutableSet;
import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.controller.ControllerBuilder;
import dev.isxander.yacl3.impl.SafeBinding;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class OptionImpl<T>
implements Option<T> {
    private final Component name;
    private OptionDescription description;
    private final Controller<T> controller;
    private final Binding<T> binding;
    private boolean available;
    private final ImmutableSet<OptionFlag> flags;
    private T pendingValue;
    private final List<BiConsumer<Option<T>, T>> listeners;
    private int listenerTriggerDepth = 0;

    public OptionImpl(@NotNull Component name, @NotNull Function<T, OptionDescription> descriptionFunction, @NotNull Function<Option<T>, Controller<T>> controlGetter, @NotNull Binding<T> binding, boolean available, ImmutableSet<OptionFlag> flags, @NotNull Collection<BiConsumer<Option<T>, T>> listeners) {
        this.name = name;
        this.binding = new SafeBinding<T>(binding);
        this.available = available;
        this.flags = flags;
        this.listeners = new ArrayList<BiConsumer<Option<T>, T>>(listeners);
        this.pendingValue = binding.getValue();
        this.controller = controlGetter.apply(this);
        this.addListener((opt, pending) -> {
            this.description = (OptionDescription)descriptionFunction.apply(pending);
        });
        this.triggerListeners(true);
    }

    @Override
    @NotNull
    public Component name() {
        return this.name;
    }

    @Override
    @NotNull
    public OptionDescription description() {
        return this.description;
    }

    @Override
    @NotNull
    public Component tooltip() {
        return this.description.text();
    }

    @Override
    @NotNull
    public Controller<T> controller() {
        return this.controller;
    }

    @Override
    @NotNull
    public Binding<T> binding() {
        return this.binding;
    }

    @Override
    public boolean available() {
        return this.available;
    }

    @Override
    public void setAvailable(boolean available) {
        boolean changed = this.available != available;
        this.available = available;
        if (changed) {
            if (!available) {
                this.pendingValue = this.binding().getValue();
            }
            this.triggerListeners(!available);
        }
    }

    @Override
    @NotNull
    public ImmutableSet<OptionFlag> flags() {
        return this.flags;
    }

    @Override
    public boolean changed() {
        return !this.binding().getValue().equals(this.pendingValue);
    }

    @Override
    @NotNull
    public T pendingValue() {
        return this.pendingValue;
    }

    @Override
    public void requestSet(@NotNull T value) {
        Validate.notNull(value, (String)"`value` cannot be null", (Object[])new Object[0]);
        this.pendingValue = value;
        this.triggerListeners(true);
    }

    @Override
    public boolean applyValue() {
        if (this.changed()) {
            this.binding().setValue(this.pendingValue);
            return true;
        }
        return false;
    }

    @Override
    public void forgetPendingValue() {
        this.requestSet(this.binding().getValue());
    }

    @Override
    public void requestSetDefault() {
        this.requestSet(this.binding().defaultValue());
    }

    @Override
    public boolean isPendingValueDefault() {
        return this.binding().defaultValue().equals(this.pendingValue());
    }

    @Override
    public void addListener(BiConsumer<Option<T>, T> changedListener) {
        this.listeners.add(changedListener);
    }

    private void triggerListeners(boolean bypass) {
        if (bypass || this.listenerTriggerDepth == 0) {
            if (this.listenerTriggerDepth > 10) {
                throw new IllegalStateException("Listener trigger depth exceeded 10! This means a listener triggered a listener etc etc 10 times deep. This is likely a bug in the mod using YACL!");
            }
            ++this.listenerTriggerDepth;
            for (BiConsumer<Option<OptionImpl>, OptionImpl> biConsumer : this.listeners) {
                try {
                    biConsumer.accept(this, (OptionImpl)this.pendingValue);
                }
                catch (Exception e) {
                    YACLConstants.LOGGER.error("Exception whilst triggering listener for option '%s'".formatted(this.name.getString()), (Throwable)e);
                }
            }
            --this.listenerTriggerDepth;
        }
    }

    @ApiStatus.Internal
    public static class BuilderImpl<T>
    implements Option.Builder<T> {
        private Component name = Component.m_237113_((String)"Name not specified!").m_130940_(ChatFormatting.RED);
        private Function<T, OptionDescription> descriptionFunction = pending -> OptionDescription.EMPTY;
        private Function<Option<T>, Controller<T>> controlGetter;
        private Binding<T> binding;
        private boolean available = true;
        private boolean instant = false;
        private final Set<OptionFlag> flags = new HashSet<OptionFlag>();
        private final List<BiConsumer<Option<T>, T>> listeners = new ArrayList<BiConsumer<Option<T>, T>>();

        @Override
        public Option.Builder<T> name(@NotNull Component name) {
            Validate.notNull((Object)name, (String)"`name` cannot be null", (Object[])new Object[0]);
            this.name = name;
            return this;
        }

        @Override
        public Option.Builder<T> description(@NotNull OptionDescription description) {
            return this.description((T opt) -> description);
        }

        @Override
        public Option.Builder<T> description(@NotNull Function<T, OptionDescription> descriptionFunction) {
            this.descriptionFunction = descriptionFunction;
            return this;
        }

        @Override
        public Option.Builder<T> controller(@NotNull Function<Option<T>, ControllerBuilder<T>> controllerBuilder) {
            Validate.notNull(controllerBuilder, (String)"`controllerBuilder` cannot be null", (Object[])new Object[0]);
            return this.customController(opt -> ((ControllerBuilder)controllerBuilder.apply((Option)opt)).build());
        }

        @Override
        public Option.Builder<T> customController(@NotNull Function<Option<T>, Controller<T>> control) {
            Validate.notNull(control, (String)"`control` cannot be null", (Object[])new Object[0]);
            this.controlGetter = control;
            return this;
        }

        @Override
        public Option.Builder<T> binding(@NotNull Binding<T> binding) {
            Validate.notNull(binding, (String)"`binding` cannot be null", (Object[])new Object[0]);
            this.binding = binding;
            return this;
        }

        @Override
        public Option.Builder<T> binding(@NotNull T def, @NotNull @NotNull Supplier<@NotNull T> getter, @NotNull @NotNull Consumer<@NotNull T> setter) {
            Validate.notNull(def, (String)"`def` must not be null", (Object[])new Object[0]);
            Validate.notNull(getter, (String)"`getter` must not be null", (Object[])new Object[0]);
            Validate.notNull(setter, (String)"`setter` must not be null", (Object[])new Object[0]);
            this.binding = Binding.generic(def, getter, setter);
            return this;
        }

        @Override
        public Option.Builder<T> available(boolean available) {
            this.available = available;
            return this;
        }

        @Override
        public Option.Builder<T> flag(OptionFlag ... flag) {
            Validate.notNull((Object)flag, (String)"`flag` must not be null", (Object[])new Object[0]);
            this.flags.addAll(Arrays.asList(flag));
            return this;
        }

        @Override
        public Option.Builder<T> flags(@NotNull Collection<? extends OptionFlag> flags) {
            Validate.notNull(flags, (String)"`flags` must not be null", (Object[])new Object[0]);
            this.flags.addAll(flags);
            return this;
        }

        @Override
        public Option.Builder<T> instant(boolean instant) {
            this.instant = instant;
            return this;
        }

        @Override
        public Option.Builder<T> listener(@NotNull BiConsumer<Option<T>, T> listener) {
            this.listeners.add(listener);
            return this;
        }

        @Override
        public Option.Builder<T> listeners(@NotNull Collection<BiConsumer<Option<T>, T>> listeners) {
            this.listeners.addAll(listeners);
            return this;
        }

        @Override
        public Option<T> build() {
            Validate.notNull(this.controlGetter, (String)"`control` must not be null when building `Option`", (Object[])new Object[0]);
            Validate.notNull(this.binding, (String)"`binding` must not be null when building `Option`", (Object[])new Object[0]);
            Validate.isTrue((!this.instant || this.flags.isEmpty() ? 1 : 0) != 0, (String)"instant application does not support option flags", (Object[])new Object[0]);
            if (this.instant) {
                this.listeners.add((opt, pendingValue) -> opt.applyValue());
            }
            return new OptionImpl<T>(this.name, this.descriptionFunction, this.controlGetter, this.binding, this.available, (ImmutableSet<OptionFlag>)ImmutableSet.copyOf(this.flags), this.listeners);
        }
    }
}

