/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.impl;

import com.google.common.collect.ImmutableSet;
import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.gui.controllers.LabelController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class LabelOptionImpl
implements LabelOption {
    private final Component label;
    private final Component name = Component.m_237113_((String)"Label Option");
    private final OptionDescription description;
    private final Component tooltip = Component.m_237119_();
    private final LabelController labelController;
    private final Binding<Component> binding;

    public LabelOptionImpl(Component label) {
        Validate.notNull((Object)label, (String)"`label` must not be null", (Object[])new Object[0]);
        this.label = label;
        this.labelController = new LabelController(this);
        this.binding = Binding.immutable(label);
        this.description = OptionDescription.createBuilder().text(this.label).build();
    }

    @Override
    @NotNull
    public Component label() {
        return this.label;
    }

    @Override
    @NotNull
    public Component name() {
        return this.name;
    }

    @Override
    @NotNull
    public OptionDescription description() {
        return this.description;
    }

    @Override
    @NotNull
    public Component tooltip() {
        return this.tooltip;
    }

    @Override
    @NotNull
    public Controller<Component> controller() {
        return this.labelController;
    }

    @Override
    @NotNull
    public Binding<Component> binding() {
        return this.binding;
    }

    @Override
    public boolean available() {
        return true;
    }

    @Override
    public void setAvailable(boolean available) {
        throw new UnsupportedOperationException("Label options cannot be disabled.");
    }

    @Override
    @NotNull
    public ImmutableSet<OptionFlag> flags() {
        return ImmutableSet.of();
    }

    @Override
    public boolean changed() {
        return false;
    }

    @Override
    @NotNull
    public Component pendingValue() {
        return this.label;
    }

    @Override
    public void requestSet(@NotNull Component value) {
    }

    @Override
    public boolean applyValue() {
        return false;
    }

    @Override
    public void forgetPendingValue() {
    }

    @Override
    public void requestSetDefault() {
    }

    @Override
    public boolean isPendingValueDefault() {
        return true;
    }

    @Override
    public boolean canResetToDefault() {
        return false;
    }

    @Override
    public void addListener(BiConsumer<Option<Component>, Component> changedListener) {
    }

    @ApiStatus.Internal
    public static final class BuilderImpl
    implements LabelOption.Builder {
        private final List<Component> lines = new ArrayList<Component>();

        @Override
        public LabelOption.Builder line(@NotNull Component line) {
            Validate.notNull((Object)line, (String)"`line` must not be null", (Object[])new Object[0]);
            this.lines.add(line);
            return this;
        }

        @Override
        public LabelOption.Builder lines(@NotNull Collection<? extends Component> lines) {
            this.lines.addAll(lines);
            return this;
        }

        @Override
        public LabelOption build() {
            MutableComponent text = Component.m_237119_();
            Iterator<Component> iterator = this.lines.iterator();
            while (iterator.hasNext()) {
                text.m_7220_(iterator.next());
                if (!iterator.hasNext()) continue;
                text.m_130946_("\n");
            }
            return new LabelOptionImpl((Component)text);
        }
    }
}

