/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.image.impl;

import com.mojang.blaze3d.platform.GlStateManager;
import dev.isxander.yacl3.debug.DebugProperties;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import dev.isxander.yacl3.gui.image.ImageRendererFactory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class ResourceTextureImage
implements ImageRenderer {
    private final ResourceLocation location;
    private final int width;
    private final int height;
    private final int textureWidth;
    private final int textureHeight;
    private final float u;
    private final float v;

    public ResourceTextureImage(ResourceLocation location, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        this.location = location;
        this.width = width;
        this.height = height;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.u = u;
        this.v = v;
    }

    @Override
    public int render(GuiGraphics graphics, int x, int y, int renderWidth, float tickDelta) {
        float ratio = (float)renderWidth / (float)this.width;
        int targetHeight = (int)((float)this.height * ratio);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        graphics.m_280168_().m_85841_(ratio, ratio, 1.0f);
        if (DebugProperties.IMAGE_FILTERING) {
            GlStateManager._texParameter((int)3553, (int)10240, (int)9729);
            GlStateManager._texParameter((int)3553, (int)10241, (int)9729);
        }
        graphics.m_280163_(this.location, 0, 0, this.u, this.v, this.width, this.height, this.textureWidth, this.textureHeight);
        graphics.m_280168_().m_85849_();
        return targetHeight;
    }

    @Override
    public void close() {
    }

    public static ImageRendererFactory createFactory(ResourceLocation location, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        return () -> () -> new ResourceTextureImage(location, u, v, width, height, textureWidth, textureHeight);
    }
}

