/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers.dropdown;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.api.utils.MutableDimension;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.ControllerPopupWidget;
import dev.isxander.yacl3.gui.controllers.dropdown.AbstractDropdownController;
import dev.isxander.yacl3.gui.controllers.dropdown.AbstractDropdownControllerElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class DropdownWidget<T>
extends ControllerPopupWidget<AbstractDropdownController<T>> {
    public static final int MAX_SHOWN_NUMBER_OF_ITEMS = 7;
    public static final int DROPDOWN_PADDING = 2;
    private final AbstractDropdownControllerElement<T, ?> dropdownElement;
    protected Dimension<Integer> dropdownDim;
    protected int firstVisibleIndex = 0;
    protected int selectedIndex = 0;

    public DropdownWidget(AbstractDropdownController<T> control, YACLScreen screen, Dimension<Integer> dim, AbstractDropdownControllerElement<T, ?> dropdownElement) {
        super(control, screen, dim, dropdownElement);
        this.dropdownElement = dropdownElement;
        this.setDimension(dim);
    }

    @Override
    public void setDimension(Dimension<Integer> dim) {
        super.setDimension(dim);
        int dropdownHeight = dim.height() * this.numberOfVisibleItems();
        int dropdownY = dim.y() - dropdownHeight - 2;
        if (dropdownY < this.screen.tabArea.m_274449_()) {
            dropdownY = dim.yLimit() + 2;
        }
        this.dropdownDim = Dimension.ofInt(dim.x(), dropdownY, dim.width(), dropdownHeight);
    }

    public int entryHeight() {
        return this.dropdownElement.getDimension().height();
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.dropdownLength() == 0) {
            return;
        }
        PoseStack matrices = graphics.m_280168_();
        matrices.m_85836_();
        matrices.m_252880_(0.0f, 0.0f, 200.0f);
        graphics.m_280246_(0.25f, 0.25f, 0.25f, 1.0f);
        graphics.m_280398_(Screen.f_279548_, this.dropdownDim.x().intValue(), this.dropdownDim.y().intValue(), 0, 0.0f, 0.0f, this.dropdownDim.width().intValue(), this.dropdownDim.height().intValue(), 32, 32);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280637_(this.dropdownDim.x().intValue(), this.dropdownDim.y().intValue(), this.dropdownDim.width().intValue(), this.dropdownDim.height().intValue(), -1);
        graphics.m_280246_(0.0f, 0.0f, 0.0f, 0.5f);
        int y = this.dropdownDim.y() + 2 + this.entryHeight() * this.selectedVisibleIndex();
        graphics.m_280509_(this.dropdownDim.x().intValue(), y, this.dropdownDim.xLimit().intValue(), y + this.entryHeight(), -1);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280637_(this.dropdownDim.x().intValue(), y, this.dropdownDim.width().intValue(), this.entryHeight(), -1);
        MutableDimension<Integer> entryDimension = Dimension.ofInt(this.dropdownDim.x() - this.dropdownElement.getDecorationPadding(), this.dropdownDim.y() + 2, this.dropdownDim.width(), this.entryHeight());
        for (int i = this.firstVisibleIndex; i < this.lastVisibleIndex(); ++i) {
            this.dropdownElement.renderDropdownEntry(graphics, (Dimension<Integer>)entryDimension, i);
            entryDimension.move(0, this.entryHeight());
        }
        matrices.m_85849_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.dropdownElement.unfocus();
            return true;
        }
        if (this.dropdownElement.m_5953_(mouseX, mouseY)) {
            return this.dropdownElement.m_6375_(mouseX, mouseY, button);
        }
        this.close();
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        if (this.m_5953_(mouseX, mouseY)) {
            if (scrollY < 0.0) {
                this.scrollDown();
            } else {
                this.scrollUp();
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, scrollY);
    }

    public void m_94757_(double mouseX, double mouseY) {
        if (this.m_5953_(mouseX, mouseY)) {
            int index = (int)((mouseY - (double)this.dropdownDim.y().intValue()) / (double)this.entryHeight());
            this.selectVisibleItem(index);
        }
    }

    @Override
    public boolean m_5953_(double mouseX, double mouseY) {
        return this.dropdownDim.isPointInside((int)mouseX, (int)mouseY);
    }

    public boolean m_5534_(char chr, int modifiers) {
        return this.dropdownElement.m_5534_(chr, modifiers);
    }

    public int dropdownLength() {
        return this.dropdownElement.matchingValues.size();
    }

    public int numberOfVisibleItems() {
        return Math.min(7, this.dropdownLength());
    }

    public int lastVisibleIndex() {
        return Math.min(this.firstVisibleIndex + 7, this.dropdownLength());
    }

    public int selectedIndex() {
        return this.selectedIndex;
    }

    public void resetSelectedIndex() {
        this.selectedIndex = 0;
    }

    public int selectedVisibleIndex() {
        return this.selectedIndex - this.firstVisibleIndex;
    }

    public void selectVisibleItem(int visibleIndex) {
        this.selectedIndex = Math.min(this.firstVisibleIndex + visibleIndex, this.dropdownLength() - 1);
    }

    public void selectNextEntry() {
        this.selectedIndex = this.selectedIndex == this.dropdownLength() - 1 ? 0 : ++this.selectedIndex;
        if (this.selectedIndex - this.firstVisibleIndex >= 3) {
            this.centerOnSelectedItem();
        }
    }

    public void selectPreviousEntry() {
        this.selectedIndex = this.selectedIndex == 0 ? this.dropdownLength() - 1 : --this.selectedIndex;
        if (this.selectedIndex - this.firstVisibleIndex <= 3) {
            this.centerOnSelectedItem();
        }
    }

    private void centerOnSelectedItem() {
        int begin = Math.max(0, this.selectedIndex - 3);
        int end = begin + 7;
        if (end >= this.dropdownLength()) {
            end = this.dropdownLength();
            begin = Math.max(0, end - 7);
        }
        this.firstVisibleIndex = begin;
    }

    public void scrollDown() {
        if (this.firstVisibleIndex + 1 + 7 <= this.dropdownLength()) {
            ++this.firstVisibleIndex;
        }
        if (this.selectedIndex < this.firstVisibleIndex) {
            this.selectedIndex = this.firstVisibleIndex;
        }
    }

    public void scrollUp() {
        if (this.firstVisibleIndex > 0) {
            --this.firstVisibleIndex;
        }
        if (this.selectedIndex > this.firstVisibleIndex + 7 - 1) {
            this.selectedIndex = this.firstVisibleIndex + 7 - 1;
        }
    }

    @Override
    public void close() {
        this.dropdownElement.removeDropdownWidget();
    }

    @Override
    public Component popupTitle() {
        return Component.m_237115_((String)"yacl.control.dropdown.dropdown_widget_title");
    }
}

