/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers;

import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.api.utils.MutableDimension;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.ColorController;
import dev.isxander.yacl3.gui.controllers.ControllerPopupWidget;
import dev.isxander.yacl3.platform.YACLPlatform;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ColorPickerWidget
extends ControllerPopupWidget<ColorController> {
    private static final ResourceLocation COLOR_PICKER_ATLAS = YACLPlatform.rl("textures/gui/colorpicker-atlas.png");
    private final ColorController controller;
    private final ColorController.ColorControllerElement entryWidget;
    protected MutableDimension<Integer> colorPickerDim;
    protected MutableDimension<Integer> previewColorDim;
    protected MutableDimension<Integer> saturationLightDim;
    protected MutableDimension<Integer> hueGradientDim;
    protected MutableDimension<Integer> alphaGradientDim;
    private boolean mouseDown;
    private boolean hueSliderDown;
    private boolean satLightGradientDown;
    private boolean alphaSliderDown;
    private int hueThumbX;
    private int satLightThumbX;
    private int alphaThumbX;
    private boolean charTyped;
    private final int outline = 1;
    private final int previewPortion = 7;
    private final int sliderHeight = 7;
    private final int paddingX = 1;
    private final int paddingY = 3;
    private float[] HSL;
    private float hue;
    private float saturation;
    private float light;
    private int alpha;

    public ColorPickerWidget(ColorController control, YACLScreen screen, Dimension<Integer> dim, ColorController.ColorControllerElement entryWidget) {
        super(control, screen, dim, entryWidget);
        this.controller = control;
        this.entryWidget = entryWidget;
        this.setDimension(dim);
        this.updateHSL();
        this.setThumbX();
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.updateHSL();
        int thumbWidth = 4;
        int thumbHeight = 4;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 10.0f);
        graphics.m_280260_(COLOR_PICKER_ATLAS, (Integer)this.colorPickerDim.x() - 5, (Integer)this.colorPickerDim.y() - 5, (Integer)this.colorPickerDim.width() + 10, (Integer)this.colorPickerDim.height() + 10, 3, 236, 34, 0, 0);
        graphics.m_280509_((Integer)this.previewColorDim.x() - 1, (Integer)this.previewColorDim.y() - 1, (Integer)this.previewColorDim.xLimit() + 1, (Integer)this.previewColorDim.yLimit() + 1, Color.black.getRGB());
        if (this.controller.allowAlpha()) {
            graphics.m_280543_(COLOR_PICKER_ATLAS, ((Integer)this.previewColorDim.x()).intValue(), ((Integer)this.previewColorDim.y()).intValue(), ((Integer)this.previewColorDim.width()).intValue(), ((Integer)this.previewColorDim.height()).intValue(), 236, 0, 8, 8);
        }
        graphics.m_280509_(((Integer)this.previewColorDim.x()).intValue(), ((Integer)this.previewColorDim.y()).intValue(), ((Integer)this.previewColorDim.xLimit()).intValue(), ((Integer)this.previewColorDim.yLimit()).intValue(), this.controller.option().pendingValue().getRGB());
        graphics.m_280509_((Integer)this.saturationLightDim.x() - 1, (Integer)this.saturationLightDim.y() - 1, (Integer)this.saturationLightDim.xLimit() + 1, (Integer)this.saturationLightDim.yLimit() + 1, Color.black.getRGB());
        this.fillSidewaysGradient(graphics, (Integer)this.saturationLightDim.x(), (Integer)this.saturationLightDim.y(), (Integer)this.saturationLightDim.xLimit(), (Integer)this.saturationLightDim.yLimit(), -1, (int)this.getRgbFromHueX());
        graphics.m_280024_(((Integer)this.saturationLightDim.x()).intValue(), ((Integer)this.saturationLightDim.y()).intValue(), ((Integer)this.saturationLightDim.xLimit()).intValue(), ((Integer)this.saturationLightDim.yLimit()).intValue(), 0, -16777216);
        graphics.m_280509_(this.satLightThumbX - thumbWidth / 2 - 2, this.getSatLightThumbY() + thumbHeight / 2 + 2, this.satLightThumbX + thumbWidth / 2 + 1, this.getSatLightThumbY() - thumbHeight / 2 - 1, -12566464);
        graphics.m_280509_(this.satLightThumbX - thumbWidth / 2 - 1, this.getSatLightThumbY() + thumbHeight / 2 + 1, this.satLightThumbX + thumbWidth / 2, this.getSatLightThumbY() - thumbHeight / 2, -1);
        graphics.m_280509_((Integer)this.hueGradientDim.x() - 1, (Integer)this.hueGradientDim.y() - 1, (Integer)this.hueGradientDim.xLimit() + 1, (Integer)this.hueGradientDim.yLimit() + 1, Color.black.getRGB());
        this.drawRainbowGradient(graphics, (Integer)this.hueGradientDim.x(), (Integer)this.hueGradientDim.y(), (Integer)this.hueGradientDim.xLimit(), (Integer)this.hueGradientDim.yLimit());
        graphics.m_280509_(this.hueThumbX - thumbWidth / 2 - 1, (Integer)this.hueGradientDim.y() - 1 - 1, this.hueThumbX + thumbWidth / 2 + 1, (Integer)this.hueGradientDim.yLimit() + 1 + 1, -12566464);
        graphics.m_280509_(this.hueThumbX - thumbWidth / 2, (Integer)this.hueGradientDim.y() - 1, this.hueThumbX + thumbWidth / 2, (Integer)this.hueGradientDim.yLimit() + 1, -1);
        if (this.controller.allowAlpha()) {
            graphics.m_280509_((Integer)this.alphaGradientDim.x() - 1, (Integer)this.alphaGradientDim.y() - 1, (Integer)this.alphaGradientDim.xLimit() + 1, (Integer)this.alphaGradientDim.yLimit() + 1, Color.black.getRGB());
            graphics.m_280543_(COLOR_PICKER_ATLAS, ((Integer)this.alphaGradientDim.x()).intValue(), ((Integer)this.alphaGradientDim.y()).intValue(), ((Integer)this.alphaGradientDim.width()).intValue(), 7, 236, 0, 8, 8);
            this.fillSidewaysGradient(graphics, (Integer)this.alphaGradientDim.x(), (Integer)this.alphaGradientDim.y(), (Integer)this.alphaGradientDim.xLimit(), (Integer)this.alphaGradientDim.yLimit(), this.getRgbWithoutAlpha(), 0);
            graphics.m_280509_(this.alphaThumbX - thumbWidth / 2 - 1, (Integer)this.alphaGradientDim.y() - 1 - 1, this.alphaThumbX + thumbWidth / 2 + 1, (Integer)this.alphaGradientDim.yLimit() + 1 + 1, -12566464);
            graphics.m_280509_(this.alphaThumbX - thumbWidth / 2, (Integer)this.alphaGradientDim.y() - 1, this.alphaThumbX + thumbWidth / 2, (Integer)this.alphaGradientDim.yLimit() + 1, -1);
        }
        graphics.m_280168_().m_85849_();
    }

    public boolean clickedHueSlider(double mouseX, double mouseY) {
        if (this.satLightGradientDown || this.alphaSliderDown) {
            return false;
        }
        if (mouseY >= (double)((Integer)this.hueGradientDim.y()).intValue() && mouseY <= (double)((Integer)this.hueGradientDim.yLimit()).intValue() && mouseX >= (double)((Integer)this.hueGradientDim.x()).intValue() && mouseX <= (double)((Integer)this.hueGradientDim.xLimit()).intValue()) {
            this.hueSliderDown = true;
        }
        if (this.hueSliderDown) {
            this.hueThumbX = (int)Mth.m_14008_((double)mouseX, (double)((Integer)this.hueGradientDim.x()).intValue(), (double)((Integer)this.hueGradientDim.xLimit()).intValue());
        }
        return this.hueSliderDown;
    }

    public boolean clickedSatLightGradient(double mouseX, double mouseY) {
        if (this.hueSliderDown || this.alphaSliderDown) {
            return false;
        }
        if (mouseX >= (double)((Integer)this.saturationLightDim.x()).intValue() && mouseX <= (double)((Integer)this.saturationLightDim.xLimit()).intValue() && mouseY >= (double)((Integer)this.saturationLightDim.y()).intValue() && mouseY <= (double)((Integer)this.saturationLightDim.yLimit()).intValue()) {
            this.satLightGradientDown = true;
        }
        if (this.satLightGradientDown) {
            this.satLightThumbX = (int)Mth.m_14008_((double)mouseX, (double)((Integer)this.saturationLightDim.x()).intValue(), (double)((Integer)this.saturationLightDim.xLimit()).intValue());
        }
        return this.satLightGradientDown;
    }

    public boolean clickedAlphaSlider(double mouseX, double mouseY) {
        if (this.satLightGradientDown || this.hueSliderDown) {
            return false;
        }
        if (mouseX >= (double)((Integer)this.alphaGradientDim.x()).intValue() && mouseX <= (double)((Integer)this.alphaGradientDim.xLimit()).intValue() && mouseY >= (double)((Integer)this.alphaGradientDim.y()).intValue() && mouseY <= (double)((Integer)this.alphaGradientDim.yLimit()).intValue()) {
            this.alphaSliderDown = true;
        }
        if (this.alphaSliderDown) {
            this.alphaThumbX = (int)Mth.m_14008_((double)mouseX, (double)((Integer)this.alphaGradientDim.x()).intValue(), (double)((Integer)this.alphaGradientDim.xLimit()).intValue());
        }
        return this.alphaSliderDown;
    }

    public void setColorFromMouseClick(double mouseX, double mouseY) {
        if (this.clickedSatLightGradient(mouseX, mouseY)) {
            this.setSatLightFromMouse(mouseX, mouseY);
        } else if (this.clickedHueSlider(mouseX, mouseY)) {
            this.setHueFromMouse(mouseX);
        } else if (this.controller.allowAlpha() && this.clickedAlphaSlider(mouseX, mouseY)) {
            this.setAlphaFromMouse(mouseX);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.mouseDown = true;
            this.hueSliderDown = false;
            this.satLightGradientDown = false;
            this.alphaSliderDown = false;
            this.setColorFromMouseClick(mouseX, mouseY);
            return true;
        }
        if (this.entryWidget.m_5953_(mouseX, mouseY)) {
            return this.entryWidget.m_6375_(mouseX, mouseY, button);
        }
        this.close();
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.mouseDown = false;
        return false;
    }

    @Override
    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseX >= (double)((Integer)this.colorPickerDim.x() - 1 - 3) && mouseX <= (double)((Integer)this.colorPickerDim.xLimit() + 1 + 3) && mouseY >= (double)((Integer)this.colorPickerDim.y() - 1 - 3) && mouseY <= (double)((Integer)this.colorPickerDim.yLimit() + 1 + 3);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.mouseDown || this.m_5953_(mouseX, mouseY)) {
            this.setColorFromMouseClick(mouseX, mouseY);
            return true;
        }
        return this.entryWidget.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_5534_(char chr, int modifiers) {
        this.charTyped = true;
        return this.entryWidget.m_5534_(chr, modifiers);
    }

    @Override
    public void setDimension(Dimension<Integer> dim) {
        super.setDimension(dim);
        int colorPickerHeight = dim.height() * 2 + 7;
        int colorPickerX = dim.centerX() - this.getXPadding() * 2;
        int colorPickerY = dim.y() - colorPickerHeight - 7;
        int alphaSliderHeight = 0;
        if (this.controller.allowAlpha()) {
            alphaSliderHeight = 11;
            colorPickerHeight += alphaSliderHeight;
            colorPickerY -= alphaSliderHeight;
        }
        if (colorPickerY < this.screen.tabArea.m_274449_()) {
            colorPickerY = dim.yLimit() + 7;
        }
        this.colorPickerDim = Dimension.ofInt(colorPickerX, colorPickerY, dim.xLimit() - colorPickerX, colorPickerHeight);
        this.previewColorDim = Dimension.ofInt((Integer)this.colorPickerDim.x(), (Integer)this.colorPickerDim.y(), (Integer)this.colorPickerDim.x() + (Integer)this.colorPickerDim.xLimit() / 7 - 1 - (Integer)this.colorPickerDim.x(), (Integer)this.colorPickerDim.yLimit() - 7 - 3 - (Integer)this.colorPickerDim.y() - alphaSliderHeight);
        this.saturationLightDim = Dimension.ofInt((Integer)this.colorPickerDim.x() + (Integer)this.colorPickerDim.xLimit() / 7 + 1 + 1, (Integer)this.colorPickerDim.y(), (Integer)this.colorPickerDim.xLimit() - ((Integer)this.colorPickerDim.x() + (Integer)this.colorPickerDim.xLimit() / 7 + 1 + 1), (Integer)this.colorPickerDim.yLimit() - 7 - 3 - (Integer)this.colorPickerDim.y() - alphaSliderHeight);
        this.hueGradientDim = Dimension.ofInt((Integer)this.colorPickerDim.x(), (Integer)this.colorPickerDim.yLimit() - 7 - alphaSliderHeight, (Integer)this.colorPickerDim.width(), 7);
        if (this.controller.allowAlpha()) {
            this.alphaGradientDim = Dimension.ofInt((Integer)this.hueGradientDim.x(), (Integer)this.hueGradientDim.y() + alphaSliderHeight, (Integer)this.hueGradientDim.width(), 7);
        }
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.entryWidget.hoveredOverColorPreview = this.entryWidget.isMouseOverColorPreview(mouseX, mouseY);
    }

    @Override
    public void close() {
        this.entryWidget.removeColorPicker();
    }

    @Override
    public Component popupTitle() {
        return Component.m_237115_((String)"yacl.control.color.color_picker_title");
    }

    public void setThumbX() {
        this.hueThumbX = this.getHueThumbX();
        this.satLightThumbX = this.getSatLightThumbX();
        if (this.controller.allowAlpha()) {
            this.alphaThumbX = this.getAlphaThumbX();
        }
    }

    protected int getHueThumbX() {
        int min = (Integer)this.hueGradientDim.x();
        int max = (Integer)this.hueGradientDim.xLimit();
        int value = (int)((float)min + (float)((Integer)this.hueGradientDim.width()).intValue() * this.hue);
        return Mth.m_14045_((int)value, (int)min, (int)max);
    }

    protected int getSatLightThumbX() {
        int min = (Integer)this.saturationLightDim.x();
        int max = (Integer)this.saturationLightDim.xLimit();
        int value = (int)((float)min + (float)((Integer)this.saturationLightDim.width()).intValue() * this.saturation);
        return Mth.m_14045_((int)value, (int)min, (int)max);
    }

    protected int getSatLightThumbY() {
        int min = (Integer)this.saturationLightDim.y();
        int max = (Integer)this.saturationLightDim.yLimit();
        int value = (int)((float)min + (float)((Integer)this.saturationLightDim.height()).intValue() * (1.0f - this.light));
        return Mth.m_14045_((int)value, (int)min, (int)max);
    }

    protected int getAlphaThumbX() {
        int min = (Integer)this.alphaGradientDim.x();
        int max = (Integer)this.alphaGradientDim.xLimit();
        int value = max - (Integer)this.alphaGradientDim.width() * this.alpha / 255;
        return Mth.m_14045_((int)value, (int)min, (int)max);
    }

    public void setHueFromMouse(double mouseX) {
        if (mouseX < (double)((Integer)this.hueGradientDim.x()).intValue()) {
            this.hue = 0.0f;
        } else if (mouseX > (double)((Integer)this.hueGradientDim.xLimit()).intValue()) {
            this.hue = 1.0f;
        } else {
            float newHue = (float)(mouseX - (double)((Integer)this.hueGradientDim.x()).intValue()) / (float)((Integer)this.hueGradientDim.width()).intValue();
            this.hue = Mth.m_14036_((float)newHue, (float)0.0f, (float)1.0f);
        }
        this.setColorControllerFromHSL();
    }

    public void setSatLightFromMouse(double mouseX, double mouseY) {
        if (mouseX < (double)((Integer)this.saturationLightDim.x()).intValue()) {
            this.saturation = 0.0f;
        } else if (mouseX > (double)((Integer)this.saturationLightDim.xLimit()).intValue()) {
            this.saturation = 1.0f;
        } else {
            float newSat = (float)(mouseX - (double)((Integer)this.saturationLightDim.x()).intValue()) / (float)((Integer)this.saturationLightDim.width()).intValue();
            this.saturation = Mth.m_14036_((float)newSat, (float)0.0f, (float)1.0f);
        }
        if (mouseY < (double)((Integer)this.saturationLightDim.y()).intValue()) {
            this.light = 1.0f;
        } else if (mouseY > (double)((Integer)this.saturationLightDim.yLimit()).intValue()) {
            this.light = 0.0f;
        } else {
            float newLight = (float)(mouseY - (double)((Integer)this.saturationLightDim.y()).intValue()) / (float)((Integer)this.saturationLightDim.height()).intValue();
            this.light = Mth.m_14036_((float)(1.0f - newLight), (float)0.0f, (float)1.0f);
        }
        this.setColorControllerFromHSL();
    }

    public void setAlphaFromMouse(double mouseX) {
        if (mouseX < (double)((Integer)this.alphaGradientDim.x()).intValue()) {
            this.alpha = 255;
        } else if (mouseX > (double)((Integer)this.alphaGradientDim.xLimit()).intValue()) {
            this.alpha = 0;
        } else {
            int newAlpha = (int)((mouseX - (double)((Integer)this.alphaGradientDim.xLimit()).intValue()) / (double)((Integer)this.alphaGradientDim.width()).intValue() * -255.0);
            this.alpha = Mth.m_14045_((int)newAlpha, (int)0, (int)255);
        }
        this.setColorControllerFromHSL();
    }

    public void setColorControllerFromHSL() {
        float trueHue = (float)(this.hueThumbX - (Integer)this.colorPickerDim.x()) / (float)((Integer)this.colorPickerDim.width()).intValue();
        Color color = Color.getHSBColor(trueHue, this.saturation, this.light);
        Color returnColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.alpha);
        this.controller.option().requestSet(returnColor);
    }

    protected void updateHSL() {
        this.HSL = this.getHSL();
        this.hue = this.hue();
        this.saturation = this.saturation();
        this.light = this.light();
        this.alpha = this.getAlpha();
        if (this.charTyped) {
            this.setThumbX();
            this.charTyped = false;
        }
    }

    protected float[] getHSL() {
        Color pendingValue = this.controller.option().pendingValue();
        return Color.RGBtoHSB(pendingValue.getRed(), pendingValue.getGreen(), pendingValue.getBlue(), null);
    }

    protected float hue() {
        return this.HSL[0];
    }

    protected float saturation() {
        return this.HSL[1];
    }

    protected float light() {
        return this.HSL[2];
    }

    protected int getAlpha() {
        return this.controller.option().pendingValue().getAlpha();
    }

    protected float getRgbFromHueX() {
        float trueHue = (float)(this.hueThumbX - (Integer)this.colorPickerDim.x()) / (float)((Integer)this.colorPickerDim.width()).intValue();
        return Color.HSBtoRGB(trueHue, 1.0f, 1.0f);
    }

    protected int getRgbWithoutAlpha() {
        Color pendingColor = this.controller.option().pendingValue();
        Color returnColor = new Color(pendingColor.getRed(), pendingColor.getGreen(), pendingColor.getBlue(), 255);
        return returnColor.getRGB();
    }
}

