/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui;

import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.utils.YACLRenderHelper;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import org.joml.Matrix4f;

public abstract class AbstractWidget
implements GuiEventListener,
Renderable,
NarratableEntry {
    protected final Minecraft client = Minecraft.m_91087_();
    protected final Font textRenderer;
    protected final int inactiveColor = -6250336;
    private Dimension<Integer> dim;

    public AbstractWidget(Dimension<Integer> dim) {
        this.textRenderer = this.client.f_91062_;
        this.inactiveColor = -6250336;
        this.dim = dim;
    }

    public boolean canReset() {
        return false;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        if (this.dim == null) {
            return false;
        }
        return this.dim.isPointInside((int)mouseX, (int)mouseY);
    }

    public void setDimension(Dimension<Integer> dim) {
        this.dim = dim;
    }

    public Dimension<Integer> getDimension() {
        return this.dim;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void unfocus() {
    }

    public boolean matchesSearch(String query) {
        return true;
    }

    public void m_142291_(NarrationElementOutput builder2) {
    }

    protected void drawButtonRect(GuiGraphics graphics, int x1, int y1, int x2, int y2, boolean hovered, boolean enabled) {
        if (x1 > x2) {
            int xx1 = x1;
            x1 = x2;
            x2 = xx1;
        }
        if (y1 > y2) {
            int yy1 = y1;
            y1 = y2;
            y2 = yy1;
        }
        int width = x2 - x1;
        int height = y2 - y1;
        YACLRenderHelper.renderButtonTexture(graphics, x1, y1, width, height, enabled, hovered);
    }

    protected void drawOutline(GuiGraphics graphics, int x1, int y1, int x2, int y2, int width, int color) {
        graphics.m_280509_(x1, y1, x2, y1 + width, color);
        graphics.m_280509_(x2, y1, x2 - width, y2, color);
        graphics.m_280509_(x1, y2, x2, y2 - width, color);
        graphics.m_280509_(x1, y1, x1 + width, y2, color);
    }

    protected void fillSidewaysGradient(GuiGraphics graphics, int x1, int y1, int x2, int y2, int startColor, int endColor) {
        VertexConsumer vertex = graphics.m_280091_().m_6299_(RenderType.m_285907_());
        Matrix4f matrix4f = graphics.m_280168_().m_85850_().m_252922_();
        vertex.m_252986_(matrix4f, (float)x1, (float)y1, 0.0f).m_193479_(startColor).m_5752_();
        vertex.m_252986_(matrix4f, (float)x1, (float)y2, 0.0f).m_193479_(startColor).m_5752_();
        vertex.m_252986_(matrix4f, (float)x2, (float)y2, 0.0f).m_193479_(endColor).m_5752_();
        vertex.m_252986_(matrix4f, (float)x2, (float)y1, 0.0f).m_193479_(endColor).m_5752_();
    }

    protected void drawRainbowGradient(GuiGraphics graphics, int x1, int y1, int x2, int y2) {
        int[] colors = new int[]{Color.red.getRGB(), Color.yellow.getRGB(), Color.green.getRGB(), Color.cyan.getRGB(), Color.blue.getRGB(), Color.magenta.getRGB(), Color.red.getRGB()};
        int width = x2 - x1;
        int maxColors = colors.length - 1;
        for (int color = 0; color < maxColors; ++color) {
            this.fillSidewaysGradient(graphics, x1 + width / maxColors * color, y1, color == maxColors - 1 ? x2 : x1 + width / maxColors * (color + 1), y2, colors[color], colors[color + 1]);
        }
    }

    protected int multiplyColor(int hex, float amount) {
        Color color = new Color(hex, true);
        return new Color(Math.max((int)((float)color.getRed() * amount), 0), Math.max((int)((float)color.getGreen() * amount), 0), Math.max((int)((float)color.getBlue() * amount), 0), color.getAlpha()).getRGB();
    }

    public void playDownSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }
}

