/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.api;

import com.google.common.collect.ImmutableSet;
import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.controller.ControllerBuilder;
import dev.isxander.yacl3.impl.OptionImpl;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public interface Option<T> {
    @NotNull
    public Component name();

    @NotNull
    public OptionDescription description();

    @Deprecated
    @NotNull
    public Component tooltip();

    @NotNull
    public Controller<T> controller();

    @NotNull
    public Binding<T> binding();

    public boolean available();

    public void setAvailable(boolean var1);

    @NotNull
    public ImmutableSet<OptionFlag> flags();

    public boolean changed();

    @NotNull
    public T pendingValue();

    public void requestSet(@NotNull T var1);

    public boolean applyValue();

    public void forgetPendingValue();

    public void requestSetDefault();

    public boolean isPendingValueDefault();

    default public boolean canResetToDefault() {
        return true;
    }

    public void addListener(BiConsumer<Option<T>, T> var1);

    public static <T> Builder<T> createBuilder() {
        return new OptionImpl.BuilderImpl();
    }

    @Deprecated
    public static <T> Builder<T> createBuilder(Class<T> typeClass) {
        return Option.createBuilder();
    }

    public static interface Builder<T> {
        public Builder<T> name(@NotNull Component var1);

        public Builder<T> description(@NotNull OptionDescription var1);

        public Builder<T> description(@NotNull Function<T, OptionDescription> var1);

        public Builder<T> controller(@NotNull Function<Option<T>, ControllerBuilder<T>> var1);

        public Builder<T> customController(@NotNull Function<Option<T>, Controller<T>> var1);

        public Builder<T> binding(@NotNull Binding<T> var1);

        public Builder<T> binding(@NotNull T var1, @NotNull @NotNull Supplier<@NotNull T> var2, @NotNull @NotNull Consumer<@NotNull T> var3);

        public Builder<T> available(boolean var1);

        public Builder<T> flag(OptionFlag ... var1);

        public Builder<T> flags(@NotNull Collection<? extends OptionFlag> var1);

        public Builder<T> instant(boolean var1);

        public Builder<T> listener(@NotNull BiConsumer<Option<T>, T> var1);

        public Builder<T> listeners(@NotNull Collection<BiConsumer<Option<T>, T>> var1);

        public Option<T> build();
    }
}

