/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.cooking.fuel;

import java.text.NumberFormat;
import java.util.List;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.vanilla.IJeiFuelingRecipe;
import mezz.jei.common.Constants;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.library.plugins.vanilla.cooking.FurnaceVariantCategory;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_8029;
import org.jetbrains.annotations.Nullable;

public class FurnaceFuelCategory
extends FurnaceVariantCategory<IJeiFuelingRecipe> {
    private final IDrawableStatic background;
    private final IDrawableStatic flameTransparentBackground;
    private final class_2561 localizedName;
    private final ImmutableRect2i textArea;
    private final IGuiHelper guiHelper;

    public FurnaceFuelCategory(IGuiHelper guiHelper, Textures textures) {
        super(guiHelper);
        this.guiHelper = guiHelper;
        class_310 minecraft = class_310.method_1551();
        class_327 fontRenderer = minecraft.field_1772;
        class_2561 maxSmeltCountText = RecipeWidget.createSmeltCountText(2000000000);
        int maxStringWidth = fontRenderer.method_1727(maxSmeltCountText.getString());
        int backgroundHeight = 34;
        int textPadding = 20;
        this.background = guiHelper.drawableBuilder(Constants.RECIPE_GUI_VANILLA, 0, 134, 18, backgroundHeight).addPadding(0, 0, 0, textPadding + maxStringWidth).build();
        this.textArea = new ImmutableRect2i(20, 0, textPadding + maxStringWidth, backgroundHeight);
        this.flameTransparentBackground = textures.getFlameIcon();
        this.localizedName = class_2561.method_43471((String)"gui.jei.category.fuel");
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public RecipeType<IJeiFuelingRecipe> getRecipeType() {
        return RecipeTypes.FUELING;
    }

    @Override
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getIcon() {
        return this.flameTransparentBackground;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, IJeiFuelingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 17).addItemStacks((List)recipe.getInputs());
    }

    @Override
    public void createRecipeExtras(IRecipeExtrasBuilder acceptor, IJeiFuelingRecipe recipe, IFocusGroup focuses) {
        acceptor.addWidget(new RecipeWidget(this.guiHelper, recipe.getBurnTime(), this.textArea));
    }

    @Override
    @Nullable
    public class_2960 getRegistryName(IJeiFuelingRecipe recipe) {
        return null;
    }

    private static class RecipeWidget
    implements IRecipeWidget {
        private final IDrawableAnimated flame;
        private final class_2561 smeltCountText;
        private final ImmutableRect2i textArea;
        private final class_8029 screenPosition;

        public RecipeWidget(IGuiHelper guiHelper, int burnTime, ImmutableRect2i textArea) {
            this.flame = guiHelper.drawableBuilder(Constants.RECIPE_GUI_VANILLA, 82, 114, 14, 14).buildAnimated(burnTime, IDrawableAnimated.StartDirection.TOP, true);
            this.smeltCountText = RecipeWidget.createSmeltCountText(burnTime);
            this.textArea = textArea;
            this.screenPosition = new class_8029(0, 0);
        }

        @Override
        public class_8029 getPosition() {
            return this.screenPosition;
        }

        @Override
        public void draw(class_332 guiGraphics, double mouseX, double mouseY) {
            this.flame.draw(guiGraphics, 1, 0);
            class_310 minecraft = class_310.method_1551();
            class_327 font = minecraft.field_1772;
            ImmutableRect2i centerArea = MathUtil.centerTextArea(this.textArea, font, (class_5348)this.smeltCountText);
            guiGraphics.method_51439(font, this.smeltCountText, centerArea.getX(), centerArea.getY(), -8355712, false);
        }

        public static class_2561 createSmeltCountText(int burnTime) {
            if (burnTime == 200) {
                return class_2561.method_43471((String)"gui.jei.category.fuel.smeltCount.single");
            }
            NumberFormat numberInstance = NumberFormat.getNumberInstance();
            numberInstance.setMaximumFractionDigits(2);
            String smeltCount = numberInstance.format((float)burnTime / 200.0f);
            return class_2561.method_43469((String)"gui.jei.category.fuel.smeltCount", (Object[])new Object[]{smeltCount});
        }
    }
}

