/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.anvil;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.common.Constants;
import mezz.jei.library.plugins.vanilla.anvil.AnvilRecipeMaker;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class AnvilRecipeCategory
implements IRecipeCategory<IJeiAnvilRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final String leftSlotName = "leftSlot";
    private final String rightSlotName = "rightSlot";

    public AnvilRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(Constants.RECIPE_GUI_VANILLA, 0, 168, 125, 18).addPadding(0, 20, 0, 0).build();
        this.icon = guiHelper.createDrawableItemStack(new class_1799((class_1935)class_2246.field_10535));
    }

    @Override
    public RecipeType<IJeiAnvilRecipe> getRecipeType() {
        return RecipeTypes.ANVIL;
    }

    @Override
    public class_2561 getTitle() {
        return class_2246.field_10535.method_9518();
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, IJeiAnvilRecipe recipe, IFocusGroup focuses) {
        List<class_1799> leftInputs = recipe.getLeftInputs();
        List<class_1799> rightInputs = recipe.getRightInputs();
        List<class_1799> outputs = recipe.getOutputs();
        IRecipeSlotBuilder leftInputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addItemStacks((List)leftInputs)).setSlotName("leftSlot");
        IRecipeSlotBuilder rightInputSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 37, 1).addItemStacks((List)rightInputs)).setSlotName("rightSlot");
        IRecipeSlotBuilder outputSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 91, 1).addItemStacks((List)outputs);
        if (leftInputs.size() == rightInputs.size()) {
            if (leftInputs.size() == outputs.size()) {
                builder.createFocusLink(leftInputSlot, rightInputSlot, outputSlot);
            }
        } else if (leftInputs.size() == outputs.size() && rightInputs.size() == 1) {
            builder.createFocusLink(leftInputSlot, outputSlot);
        } else if (rightInputs.size() == outputs.size() && leftInputs.size() == 1) {
            builder.createFocusLink(rightInputSlot, outputSlot);
        }
    }

    @Override
    public void draw(IJeiAnvilRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        Optional leftStack = recipeSlotsView.findSlotByName("leftSlot").flatMap(IRecipeSlotView::getDisplayedItemStack);
        Optional rightStack = recipeSlotsView.findSlotByName("rightSlot").flatMap(IRecipeSlotView::getDisplayedItemStack);
        if (leftStack.isEmpty() || rightStack.isEmpty()) {
            return;
        }
        int cost = AnvilRecipeMaker.findLevelsCost((class_1799)leftStack.get(), (class_1799)rightStack.get());
        String costText = cost < 0 ? "err" : Integer.toString(cost);
        String text = class_1074.method_4662((String)"container.repair.cost", (Object[])new Object[]{costText});
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        int mainColor = AnvilRecipeCategory.playerHasEnoughLevels(player, cost) ? -8323296 : -40864;
        this.drawRepairCost(minecraft, guiGraphics, text, mainColor);
    }

    @Override
    @Nullable
    public class_2960 getRegistryName(IJeiAnvilRecipe recipe) {
        return recipe.getUid();
    }

    private static boolean playerHasEnoughLevels(@Nullable class_746 player, int cost) {
        if (player == null) {
            return true;
        }
        if (player.method_7337()) {
            return true;
        }
        return cost < 40 && cost <= player.field_7520;
    }

    private void drawRepairCost(class_310 minecraft, class_332 guiGraphics, String text, int mainColor) {
        int width = minecraft.field_1772.method_1727(text);
        int x = this.getWidth() - 2 - width;
        int y = 27;
        guiGraphics.method_25303(minecraft.field_1772, text, x, y, mainColor);
    }
}

