/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.recipes;

import java.util.Optional;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OutputSlotTooltipCallback
implements IRecipeSlotRichTooltipCallback {
    private static final Logger LOGGER = LogManager.getLogger();
    private final class_2960 recipeName;

    public OutputSlotTooltipCallback(class_2960 recipeName) {
        this.recipeName = recipeName;
    }

    @Override
    public void onRichTooltip(IRecipeSlotView recipeSlotView, ITooltipBuilder tooltip) {
        boolean showAdvanced;
        String recipeModId;
        String ingredientModId;
        if (recipeSlotView.getRole() != RecipeIngredientRole.OUTPUT) {
            return;
        }
        Optional<ITypedIngredient<?>> displayedIngredient = recipeSlotView.getDisplayedIngredient();
        if (displayedIngredient.isEmpty()) {
            return;
        }
        IModIdHelper modIdHelper = Internal.getJeiRuntime().getJeiHelpers().getModIdHelper();
        if (modIdHelper.isDisplayingModNameEnabled() && (ingredientModId = this.getDisplayModId(displayedIngredient.get())) != null && !(recipeModId = this.recipeName.method_12836()).equals(ingredientModId)) {
            String modName = modIdHelper.getFormattedModNameForModId(recipeModId);
            class_5250 recipeBy = class_2561.method_43469((String)"jei.tooltip.recipe.by", (Object[])new Object[]{modName});
            tooltip.add((class_5348)recipeBy.method_27692(class_124.field_1080));
        }
        class_310 minecraft = class_310.method_1551();
        boolean bl = showAdvanced = minecraft.field_1690.field_1827 || class_437.method_25442();
        if (showAdvanced) {
            class_5250 recipeId = class_2561.method_43469((String)"jei.tooltip.recipe.id", (Object[])new Object[]{class_2561.method_43470((String)this.recipeName.toString())});
            tooltip.add((class_5348)recipeId.method_27692(class_124.field_1063));
        }
    }

    @Nullable
    private <T> String getDisplayModId(ITypedIngredient<T> typedIngredient) {
        IIngredientManager ingredientManager = Internal.getJeiRuntime().getIngredientManager();
        IIngredientType<T> type = typedIngredient.getType();
        T ingredient = typedIngredient.getIngredient();
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(type);
        try {
            return ingredientHelper.getDisplayModId(ingredient);
        }
        catch (RuntimeException e) {
            String ingredientInfo = ErrorUtil.getIngredientInfo(ingredient, type, ingredientManager);
            LOGGER.error("Caught exception from ingredient without a resource location: {}", (Object)ingredientInfo, (Object)e);
            return null;
        }
    }
}

