/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties.overlay;

import java.util.Locale;
import java.util.Properties;
import me.pepperbell.continuity.client.ContinuityClient;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class OverlayPropertiesSection {
    protected Properties properties;
    protected ResourceLocation resourceId;
    protected String packId;
    protected int tintIndex = -1;
    @Nullable
    protected BlockState tintBlock;
    protected BlendMode layer = BlendMode.CUTOUT_MIPPED;

    public OverlayPropertiesSection(Properties properties, ResourceLocation resourceId, String packId) {
        this.properties = properties;
        this.resourceId = resourceId;
        this.packId = packId;
    }

    public void init() {
        this.parseTintIndex();
        this.parseTintBlock();
        this.parseLayer();
    }

    protected void parseTintIndex() {
        String tintIndexStr = this.properties.getProperty("tintIndex");
        if (tintIndexStr == null) {
            return;
        }
        try {
            int tintIndex = Integer.parseInt(tintIndexStr.trim());
            if (tintIndex >= 0) {
                this.tintIndex = tintIndex;
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ContinuityClient.LOGGER.warn("Invalid 'tintIndex' value '" + tintIndexStr + "' in file '" + this.resourceId + "' in pack '" + this.packId + "'");
    }

    protected void parseTintBlock() {
        String tintBlockStr = this.properties.getProperty("tintBlock");
        if (tintBlockStr == null) {
            return;
        }
        String[] parts = tintBlockStr.trim().split(":", 3);
        if (parts.length != 0) {
            ResourceLocation blockId;
            try {
                blockId = parts.length == 1 || parts[1].contains("=") ? new ResourceLocation(parts[0]) : new ResourceLocation(parts[0], parts[1]);
            }
            catch (ResourceLocationException e) {
                ContinuityClient.LOGGER.warn("Invalid 'tintBlock' value '" + tintBlockStr + "' in file '" + this.resourceId + "' in pack '" + this.packId + "'", (Throwable)e);
                return;
            }
            if (BuiltInRegistries.f_256975_.m_7804_(blockId)) {
                Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(blockId);
                this.tintBlock = block.m_49966_();
            } else {
                ContinuityClient.LOGGER.warn("Unknown block '" + blockId + "' in 'tintBlock' value '" + tintBlockStr + "' in file '" + this.resourceId + "' in pack '" + this.packId + "'");
            }
        } else {
            ContinuityClient.LOGGER.warn("Invalid 'tintBlock' value '" + tintBlockStr + "' in file '" + this.resourceId + "' in pack '" + this.packId + "'");
        }
    }

    protected void parseLayer() {
        String layerStr1;
        String layerStr = this.properties.getProperty("layer");
        if (layerStr == null) {
            return;
        }
        switch (layerStr1 = layerStr.trim().toLowerCase(Locale.ROOT)) {
            case "cutout_mipped": {
                this.layer = BlendMode.CUTOUT_MIPPED;
                break;
            }
            case "cutout": {
                this.layer = BlendMode.CUTOUT;
                break;
            }
            case "translucent": {
                this.layer = BlendMode.TRANSLUCENT;
                break;
            }
            default: {
                ContinuityClient.LOGGER.warn("Unknown 'layer' value '" + layerStr + " in file '" + this.resourceId + "' in pack '" + this.packId + "'");
            }
        }
    }

    public int getTintIndex() {
        return this.tintIndex;
    }

    @Nullable
    public BlockState getTintBlock() {
        return this.tintBlock;
    }

    public BlendMode getLayer() {
        return this.layer;
    }

    public static interface Provider {
        public OverlayPropertiesSection getOverlayPropertiesSection();
    }
}

