/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.function.Predicate;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.properties.BaseCtmProperties;
import me.pepperbell.continuity.client.util.SpriteCalculator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class BasicConnectingCtmProperties
extends BaseCtmProperties {
    protected ConnectionPredicate connectionPredicate;
    protected Predicate<TagKey<Block>> tagPredicate;

    public BasicConnectingCtmProperties(Properties properties, ResourceLocation resourceId, PackResources pack, int packPriority, ResourceManager resourceManager, String method) {
        super(properties, resourceId, pack, packPriority, resourceManager, method);
    }

    @Override
    public void init() {
        super.init();
        this.parseConnect();
        this.parseTags();
        this.detectConnect();
        this.validateConnect();
    }

    protected void parseConnect() {
        String connectStr = this.properties.getProperty("connect");
        if (connectStr == null) {
            return;
        }
        try {
            this.connectionPredicate = ConnectionType.valueOf(connectStr.trim().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void parseTags() {
        String tagsStr = this.properties.getProperty("tags");
        if (tagsStr == null) {
            return;
        }
        String[] tagStrs = tagsStr.trim().split("[ ,]");
        if (tagStrs.length != 0) {
            final ObjectOpenHashSet tagHolderSet = new ObjectOpenHashSet();
            for (int i = 0; i < tagStrs.length; ++i) {
                String tagStr = tagStrs[i];
                if (tagStr.isEmpty()) continue;
                ResourceLocation tagId = new ResourceLocation(tagStr);
                TagKey key = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)tagId);
                tagHolderSet.add((Object)key);
            }
            this.tagPredicate = new Predicate<TagKey<Block>>(){

                @Override
                public boolean test(TagKey<Block> blockTagKey) {
                    return tagHolderSet.contains(blockTagKey);
                }
            };
        }
    }

    public Predicate<TagKey<Block>> getTagPredicate() {
        return this.tagPredicate;
    }

    protected void detectConnect() {
        if (this.connectionPredicate == null) {
            if (this.matchBlocksPredicate != null) {
                this.connectionPredicate = ConnectionType.BLOCK;
            } else if (this.matchTilesSet != null) {
                this.connectionPredicate = ConnectionType.TILE;
            }
        }
    }

    protected void validateConnect() {
        if (this.connectionPredicate == null) {
            ContinuityClient.LOGGER.error("No valid connection type provided in file '" + this.resourceId + "' in pack '" + this.packId + "'");
            this.valid = false;
        }
    }

    public ConnectionPredicate getConnectionPredicate() {
        return this.connectionPredicate;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ConnectionType implements ConnectionPredicate
    {
        VINE{

            @Override
            public boolean shouldConnect(BlockAndTintGetter blockView, BlockState appearanceState, BlockState state, BlockPos pos, BlockState otherAppearanceState, BlockState otherState, BlockPos otherPos, Direction face, TextureAtlasSprite quadSprite) {
                return otherAppearanceState.m_60734_().m_49962_(otherAppearanceState).equals(SoundType.f_56760_);
            }
        }
        ,
        METAL{

            @Override
            public boolean shouldConnect(BlockAndTintGetter blockView, BlockState appearanceState, BlockState state, BlockPos pos, BlockState otherAppearanceState, BlockState otherState, BlockPos otherPos, Direction face, TextureAtlasSprite quadSprite) {
                return otherAppearanceState.m_60734_().m_49962_(otherAppearanceState).equals(SoundType.f_56743_);
            }
        }
        ,
        PLANTS{

            @Override
            public boolean shouldConnect(BlockAndTintGetter blockView, BlockState appearanceState, BlockState state, BlockPos pos, BlockState otherAppearanceState, BlockState otherState, BlockPos otherPos, Direction face, TextureAtlasSprite quadSprite) {
                return otherAppearanceState.m_60734_().m_49962_(otherAppearanceState).equals(SoundType.f_56740_) && otherAppearanceState.m_60734_().m_155943_() == 0.0f;
            }
        }
        ,
        LEAVES{

            @Override
            public boolean shouldConnect(BlockAndTintGetter blockView, BlockState appearanceState, BlockState state, BlockPos pos, BlockState otherAppearanceState, BlockState otherState, BlockPos otherPos, Direction face, TextureAtlasSprite quadSprite) {
                return otherAppearanceState.m_204336_(BlockTags.f_13035_);
            }
        }
        ,
        SOIL{

            @Override
            public boolean shouldConnect(BlockAndTintGetter blockView, BlockState appearanceState, BlockState state, BlockPos pos, BlockState otherAppearanceState, BlockState otherState, BlockPos otherPos, Direction face, TextureAtlasSprite quadSprite) {
                SoundType soundGroup = otherAppearanceState.m_60734_().m_49962_(otherAppearanceState);
                return soundGroup.equals(SoundType.f_56739_) || soundGroup.equals(SoundType.f_56746_) || soundGroup.equals(SoundType.f_56740_);
            }
        }
        ,
        WOOD{

            @Override
            public boolean shouldConnect(BlockAndTintGetter blockView, BlockState appearanceState, BlockState state, BlockPos pos, BlockState otherAppearanceState, BlockState otherState, BlockPos otherPos, Direction face, TextureAtlasSprite quadSprite) {
                return otherAppearanceState.m_60734_().m_49962_(otherAppearanceState).equals(SoundType.f_56736_);
            }
        }
        ,
        STONE{

            @Override
            public boolean shouldConnect(BlockAndTintGetter blockView, BlockState appearanceState, BlockState state, BlockPos pos, BlockState otherAppearanceState, BlockState otherState, BlockPos otherPos, Direction face, TextureAtlasSprite quadSprite) {
                return otherAppearanceState.m_60734_().m_49962_(otherAppearanceState).equals(SoundType.f_56742_) && !otherAppearanceState.m_60795_();
            }
        }
        ,
        BLOCK{

            @Override
            public boolean shouldConnect(BlockAndTintGetter blockView, BlockState appearanceState, BlockState state, BlockPos pos, BlockState otherAppearanceState, BlockState otherState, BlockPos otherPos, Direction face, TextureAtlasSprite quadSprite) {
                return appearanceState.m_60734_() == otherAppearanceState.m_60734_();
            }
        }
        ,
        TILE{

            @Override
            public boolean shouldConnect(BlockAndTintGetter blockView, BlockState appearanceState, BlockState state, BlockPos pos, BlockState otherAppearanceState, BlockState otherState, BlockPos otherPos, Direction face, TextureAtlasSprite quadSprite) {
                if (appearanceState == otherAppearanceState) {
                    return true;
                }
                return quadSprite == SpriteCalculator.getSprite(otherAppearanceState, face);
            }
        }
        ,
        STATE{

            @Override
            public boolean shouldConnect(BlockAndTintGetter blockView, BlockState appearanceState, BlockState state, BlockPos pos, BlockState otherAppearanceState, BlockState otherState, BlockPos otherPos, Direction face, TextureAtlasSprite quadSprite) {
                return appearanceState == otherAppearanceState;
            }
        };

    }
}

