/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor.simple;

import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.processor.AbstractQuadProcessorFactory;
import me.pepperbell.continuity.client.processor.BaseProcessingPredicate;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import me.pepperbell.continuity.client.processor.simple.SpriteProvider;
import me.pepperbell.continuity.client.properties.BaseCtmProperties;
import me.pepperbell.continuity.client.util.QuadUtil;
import me.pepperbell.continuity.client.util.TextureUtil;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SimpleQuadProcessor
implements QuadProcessor {
    protected SpriteProvider spriteProvider;
    protected ProcessingPredicate processingPredicate;

    public SimpleQuadProcessor(SpriteProvider spriteProvider, ProcessingPredicate processingPredicate) {
        this.spriteProvider = spriteProvider;
        this.processingPredicate = processingPredicate;
    }

    @Override
    public QuadProcessor.ProcessingResult processQuad(MutableQuadView quad, TextureAtlasSprite sprite, BlockAndTintGetter blockView, BlockState appearanceState, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, int pass, QuadProcessor.ProcessingContext context) {
        if (!this.processingPredicate.shouldProcessQuad((QuadView)quad, sprite, blockView, appearanceState, state, pos, context)) {
            return QuadProcessor.ProcessingResult.NEXT_PROCESSOR;
        }
        TextureAtlasSprite newSprite = this.spriteProvider.getSprite((QuadView)quad, sprite, blockView, appearanceState, state, pos, randomSupplier, context);
        return SimpleQuadProcessor.process(quad, sprite, newSprite);
    }

    public static QuadProcessor.ProcessingResult process(MutableQuadView quad, TextureAtlasSprite oldSprite, @Nullable TextureAtlasSprite newSprite) {
        if (newSprite == null) {
            return QuadProcessor.ProcessingResult.STOP;
        }
        if (TextureUtil.isMissingSprite(newSprite)) {
            return QuadProcessor.ProcessingResult.NEXT_PROCESSOR;
        }
        QuadUtil.interpolate(quad, oldSprite, newSprite);
        return QuadProcessor.ProcessingResult.NEXT_PASS;
    }

    public static class Factory<T extends BaseCtmProperties>
    extends AbstractQuadProcessorFactory<T> {
        protected SpriteProvider.Factory<? super T> spriteProviderFactory;

        public Factory(SpriteProvider.Factory<? super T> spriteProviderFactory) {
            this.spriteProviderFactory = spriteProviderFactory;
        }

        @Override
        public QuadProcessor createProcessor(T properties, TextureAtlasSprite[] sprites) {
            return new SimpleQuadProcessor(this.spriteProviderFactory.createSpriteProvider(sprites, properties), BaseProcessingPredicate.fromProperties(properties));
        }

        @Override
        public int getTextureAmount(T properties) {
            return this.spriteProviderFactory.getTextureAmount(properties);
        }
    }
}

