/*
 * Decompiled with CFR 0.152.
 */
package com.foopy.forgeskyboxes.util.object;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class Rotation {
    public static final Rotation DEFAULT = new Rotation(true, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3i(0, 0, 0), 0.0f, 0.0f, 0.0f);
    public static final Rotation DECORATIONS = new Rotation(false, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3i(0, 0, 0), 0.0f, 0.0f, 1.0f);
    private static final Codec<Vector3f> VEC_3_F = Codec.FLOAT.listOf().comapFlatMap(list -> {
        if (list.size() < 3) {
            return DataResult.error(() -> "Incomplete number of elements in vector");
        }
        return DataResult.success((Object)new Vector3f(((Float)list.get(0)).floatValue(), ((Float)list.get(1)).floatValue(), ((Float)list.get(2)).floatValue()));
    }, vec -> ImmutableList.of((Object)Float.valueOf(vec.x()), (Object)Float.valueOf(vec.y()), (Object)Float.valueOf(vec.z())));
    private static final Codec<Vector3i> VEC_3_I = Codec.INT.listOf().comapFlatMap(list -> {
        if (list.size() < 3) {
            return DataResult.error(() -> "Incomplete number of elements in vector");
        }
        return DataResult.success((Object)new Vector3i(((Integer)list.get(0)).intValue(), ((Integer)list.get(1)).intValue(), ((Integer)list.get(2)).intValue()));
    }, vec -> ImmutableList.of((Object)vec.x(), (Object)vec.y(), (Object)vec.z()));
    public static final Codec<Rotation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("skyboxRotation", (Object)true).forGetter(Rotation::getSkyboxRotation), (App)VEC_3_F.optionalFieldOf("static", (Object)new Vector3f(0.0f, 0.0f, 0.0f)).forGetter(Rotation::getStatic), (App)VEC_3_F.optionalFieldOf("axis", (Object)new Vector3f(0.0f, 0.0f, 0.0f)).forGetter(Rotation::getAxis), (App)VEC_3_I.optionalFieldOf("timeShift", (Object)new Vector3i(0, 0, 0)).forGetter(Rotation::getTimeShift), (App)Codec.FLOAT.optionalFieldOf("rotationSpeedX", (Object)Float.valueOf(0.0f)).forGetter(Rotation::getRotationSpeedX), (App)Codec.FLOAT.optionalFieldOf("rotationSpeedY", (Object)Float.valueOf(0.0f)).forGetter(Rotation::getRotationSpeedY), (App)Codec.FLOAT.optionalFieldOf("rotationSpeedZ", (Object)Float.valueOf(0.0f)).forGetter(Rotation::getRotationSpeedZ)).apply((Applicative)instance, Rotation::new));
    private final boolean skyboxRotation;
    private final Vector3f staticRot;
    private final Vector3f axisRot;
    private final Vector3i timeShift;
    private final float rotationSpeedX;
    private final float rotationSpeedY;
    private final float rotationSpeedZ;

    public Rotation(boolean skyboxRotation, Vector3f staticRot, Vector3f axisRot, Vector3i timeShift, float rotationSpeedX, float rotationSpeedY, float rotationSpeedZ) {
        this.skyboxRotation = skyboxRotation;
        this.staticRot = staticRot;
        this.axisRot = axisRot;
        this.timeShift = timeShift;
        this.rotationSpeedX = rotationSpeedX;
        this.rotationSpeedY = rotationSpeedY;
        this.rotationSpeedZ = rotationSpeedZ;
    }

    public boolean getSkyboxRotation() {
        return this.skyboxRotation;
    }

    public Vector3f getStatic() {
        return this.staticRot;
    }

    public Vector3f getAxis() {
        return this.axisRot;
    }

    public Vector3i getTimeShift() {
        return this.timeShift;
    }

    public float getRotationSpeedX() {
        return this.rotationSpeedX;
    }

    public float getRotationSpeedY() {
        return this.rotationSpeedY;
    }

    public float getRotationSpeedZ() {
        return this.rotationSpeedZ;
    }
}

