/*
 * Decompiled with CFR 0.152.
 */
package com.foopy.forgeskyboxes.util.object;

import com.foopy.forgeskyboxes.util.Utils;
import com.foopy.forgeskyboxes.util.object.MinMaxEntry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;

public class Loop {
    public static final Loop DEFAULT = new Loop(7.0, (List<MinMaxEntry>)ImmutableList.of());
    public static final Codec<Loop> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Utils.getClampedDouble(1.0, Double.MAX_VALUE).optionalFieldOf("days", (Object)7.0).forGetter(Loop::getDays), (App)MinMaxEntry.CODEC.listOf().optionalFieldOf("ranges", (Object)ImmutableList.of()).forGetter(Loop::getRanges)).apply((Applicative)instance, Loop::new));
    private final double days;
    private final List<MinMaxEntry> ranges;

    public Loop(double days, List<MinMaxEntry> ranges) {
        this.days = days;
        this.ranges = ranges;
    }

    public double getDays() {
        return this.days;
    }

    public List<MinMaxEntry> getRanges() {
        return this.ranges;
    }

    public static class Builder {
        private final List<MinMaxEntry> ranges = Lists.newArrayList();
        private double days = 1.0;

        public Builder days(double days) {
            this.days = days;
            return this;
        }

        public Builder ranges(Collection<MinMaxEntry> worldIds) {
            this.ranges.addAll(worldIds);
            return this;
        }

        public Loop build() {
            return new Loop(this.days, this.ranges);
        }
    }
}

