/*
 * Decompiled with CFR 0.152.
 */
package com.foopy.forgeskyboxes.util.object;

import com.foopy.forgeskyboxes.util.Utils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public class Fade {
    public static final Fade DEFAULT = new Fade(0, 0, 0, 0, false);
    public static final Codec<Fade> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("startFadeIn", (Object)0).forGetter(Fade::getStartFadeIn), (App)Codec.INT.optionalFieldOf("endFadeIn", (Object)0).forGetter(Fade::getEndFadeIn), (App)Codec.INT.optionalFieldOf("startFadeOut", (Object)0).forGetter(Fade::getStartFadeOut), (App)Codec.INT.optionalFieldOf("endFadeOut", (Object)0).forGetter(Fade::getEndFadeOut), (App)Codec.BOOL.optionalFieldOf("alwaysOn", (Object)false).forGetter(Fade::isAlwaysOn)).apply((Applicative)instance, Fade::new));
    private final int startFadeIn;
    private final int endFadeIn;
    private final int startFadeOut;
    private final int endFadeOut;
    private final boolean alwaysOn;

    public Fade(int startFadeIn, int endFadeIn, int startFadeOut, int endFadeOut, boolean alwaysOn) {
        this.startFadeIn = Fade.normalizeAndWarnIfDifferent(startFadeIn, alwaysOn);
        this.endFadeIn = Fade.normalizeAndWarnIfDifferent(endFadeIn, alwaysOn);
        this.startFadeOut = Fade.normalizeAndWarnIfDifferent(startFadeOut, alwaysOn);
        this.endFadeOut = Fade.normalizeAndWarnIfDifferent(endFadeOut, alwaysOn);
        this.alwaysOn = alwaysOn;
    }

    private static int normalizeAndWarnIfDifferent(int time, boolean ignore) {
        if (ignore) {
            return time;
        }
        int normalized = Utils.normalizeTickTime(time);
        return Utils.warnIfDifferent(time, normalized, String.format("Provided time of %s has been normalized to %s", time, normalized));
    }

    public int getStartFadeIn() {
        return this.startFadeIn;
    }

    public int getEndFadeIn() {
        return this.endFadeIn;
    }

    public int getStartFadeOut() {
        return this.startFadeOut;
    }

    public int getEndFadeOut() {
        return this.endFadeOut;
    }

    public boolean isAlwaysOn() {
        return this.alwaysOn;
    }
}

