/*
 * Decompiled with CFR 0.152.
 */
package com.foopy.forgeskyboxes.util.object;

import com.foopy.forgeskyboxes.util.object.Loop;
import com.foopy.forgeskyboxes.util.object.MinMaxEntry;
import com.foopy.forgeskyboxes.util.object.Weather;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class Conditions {
    public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.listOf().optionalFieldOf("biomes", (Object)ImmutableList.of()).forGetter(Conditions::getBiomes), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("worlds", (Object)ImmutableList.of()).forGetter(Conditions::getWorlds), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("dimensions", (Object)ImmutableList.of()).forGetter(Conditions::getDimensions), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("effects", (Object)ImmutableList.of()).forGetter(Conditions::getEffects), (App)Weather.CODEC.listOf().optionalFieldOf("weather", (Object)ImmutableList.of()).forGetter(Conditions::getWeathers), (App)MinMaxEntry.CODEC.listOf().optionalFieldOf("xRanges", (Object)ImmutableList.of()).forGetter(Conditions::getXRanges), (App)MinMaxEntry.CODEC.listOf().optionalFieldOf("yRanges", (Object)ImmutableList.of()).forGetter(Conditions::getYRanges), (App)MinMaxEntry.CODEC.listOf().optionalFieldOf("zRanges", (Object)ImmutableList.of()).forGetter(Conditions::getZRanges), (App)Loop.CODEC.optionalFieldOf("loop", (Object)Loop.DEFAULT).forGetter(Conditions::getLoop)).apply((Applicative)instance, Conditions::new));
    public static final Conditions DEFAULT = new Builder().build();
    private final List<ResourceLocation> biomes;
    private final List<ResourceLocation> worlds;
    private final List<ResourceLocation> dimensions;
    private final List<ResourceLocation> effects;
    private final List<Weather> weathers;
    private final List<MinMaxEntry> yRanges;
    private final List<MinMaxEntry> zRanges;
    private final List<MinMaxEntry> xRanges;
    private final Loop loop;

    public Conditions(List<ResourceLocation> biomes, List<ResourceLocation> worlds, List<ResourceLocation> dimensions, List<ResourceLocation> effects, List<Weather> weathers, List<MinMaxEntry> xRanges, List<MinMaxEntry> yRanges, List<MinMaxEntry> zRanges, Loop loop) {
        this.biomes = biomes;
        this.worlds = worlds;
        this.dimensions = dimensions;
        this.effects = effects;
        this.weathers = weathers;
        this.xRanges = xRanges;
        this.yRanges = yRanges;
        this.zRanges = zRanges;
        this.loop = loop;
    }

    public List<ResourceLocation> getBiomes() {
        return this.biomes;
    }

    public List<ResourceLocation> getWorlds() {
        return this.worlds;
    }

    public List<ResourceLocation> getDimensions() {
        return this.dimensions;
    }

    public List<ResourceLocation> getEffects() {
        return this.effects;
    }

    public List<Weather> getWeathers() {
        return this.weathers;
    }

    public List<MinMaxEntry> getYRanges() {
        return this.yRanges;
    }

    public List<MinMaxEntry> getXRanges() {
        return this.xRanges;
    }

    public List<MinMaxEntry> getZRanges() {
        return this.zRanges;
    }

    public Loop getLoop() {
        return this.loop;
    }

    public static class Builder {
        private final List<ResourceLocation> biomes = Lists.newArrayList();
        private final List<ResourceLocation> worlds = Lists.newArrayList();
        private final List<ResourceLocation> dimensions = Lists.newArrayList();
        private final List<ResourceLocation> effects = Lists.newArrayList();
        private final List<Weather> weathers = Lists.newArrayList();
        private final List<MinMaxEntry> yRanges = Lists.newArrayList();
        private final List<MinMaxEntry> zRanges = Lists.newArrayList();
        private final List<MinMaxEntry> xRanges = Lists.newArrayList();
        private Loop loop = Loop.DEFAULT;

        public Builder biomes(Collection<ResourceLocation> biomeIds) {
            this.biomes.addAll(biomeIds);
            return this;
        }

        public Builder worlds(Collection<ResourceLocation> worldIds) {
            this.worlds.addAll(worldIds);
            return this;
        }

        public Builder dimensions(Collection<ResourceLocation> dimensionIds) {
            this.dimensions.addAll(dimensionIds);
            return this;
        }

        public Builder effects(Collection<ResourceLocation> effectIds) {
            this.effects.addAll(effectIds);
            return this;
        }

        public Builder weather(Collection<Weather> weathers) {
            this.weathers.addAll(weathers);
            return this;
        }

        public Builder yRanges(Collection<MinMaxEntry> heights) {
            this.yRanges.addAll(heights);
            return this;
        }

        public Builder zRanges(Collection<MinMaxEntry> zRanges) {
            this.zRanges.addAll(zRanges);
            return this;
        }

        public Builder xRanges(Collection<MinMaxEntry> xRanges) {
            this.xRanges.addAll(xRanges);
            return this;
        }

        public Builder biomes(ResourceLocation ... biomeIds) {
            return this.biomes(Lists.newArrayList((Object[])biomeIds));
        }

        public Builder worlds(ResourceLocation ... worldIds) {
            return this.worlds(Lists.newArrayList((Object[])worldIds));
        }

        public Builder weather(Weather ... weathers) {
            return this.weather(Lists.newArrayList((Object[])weathers));
        }

        public Builder xRanges(MinMaxEntry ... xRanges) {
            return this.xRanges(Lists.newArrayList((Object[])xRanges));
        }

        public Builder yRanges(MinMaxEntry ... yRanges) {
            return this.yRanges(Lists.newArrayList((Object[])yRanges));
        }

        public Builder zRanges(MinMaxEntry ... zRanges) {
            return this.zRanges(Lists.newArrayList((Object[])zRanges));
        }

        public Builder loop(Loop loop) {
            this.loop = loop;
            return this;
        }

        public Conditions build() {
            return new Conditions(this.biomes, this.worlds, this.dimensions, this.effects, this.weathers, this.xRanges, this.yRanges, this.zRanges, this.loop);
        }
    }
}

