/*
 * Decompiled with CFR 0.152.
 */
package com.foopy.forgeskyboxes.util.object;

import com.foopy.forgeskyboxes.util.Utils;
import com.foopy.forgeskyboxes.util.object.Texture;
import com.foopy.forgeskyboxes.util.object.UVRange;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;

public class Animation {
    public static final Codec<Animation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Texture.CODEC.fieldOf("texture").forGetter(Animation::getTexture), (App)UVRange.CODEC.fieldOf("uvRanges").forGetter(Animation::getUvRanges), (App)Utils.getClampedInteger(1, Integer.MAX_VALUE).fieldOf("gridColumns").forGetter(Animation::getGridColumns), (App)Utils.getClampedInteger(1, Integer.MAX_VALUE).fieldOf("gridRows").forGetter(Animation::getGridRows), (App)Utils.getClampedInteger(1, Integer.MAX_VALUE).fieldOf("duration").forGetter(Animation::getDuration), (App)Codec.BOOL.optionalFieldOf("interpolate", (Object)true).forGetter(Animation::isInterpolate), (App)Codec.unboundedMap((Codec)Codec.INT, (Codec)Codec.INT).optionalFieldOf("frameDuration", new HashMap()).forGetter(Animation::getFrameDuration)).apply((Applicative)instance, Animation::new));
    private final Texture texture;
    private final UVRange uvRange;
    private final int gridRows;
    private final int gridColumns;
    private final int duration;
    private final boolean interpolate;
    private final Map<Integer, Integer> frameDuration;
    private UVRange currentFrame;
    private int index;
    private long nextTime;

    public Animation(Texture texture, UVRange uvRange, int gridColumns, int gridRows, int duration, boolean interpolate, Map<Integer, Integer> frameDuration) {
        this.texture = texture;
        this.uvRange = uvRange;
        this.gridColumns = gridColumns;
        this.gridRows = gridRows;
        this.duration = duration;
        this.interpolate = interpolate;
        this.frameDuration = frameDuration;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public UVRange getUvRanges() {
        return this.uvRange;
    }

    public int getGridColumns() {
        return this.gridColumns;
    }

    public int getGridRows() {
        return this.gridRows;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isInterpolate() {
        return this.interpolate;
    }

    public Map<Integer, Integer> getFrameDuration() {
        return this.frameDuration;
    }

    public void tick() {
        if (this.nextTime <= Util.m_137574_()) {
            this.index = (this.index + 1) % (this.gridRows * this.gridColumns);
            this.currentFrame = this.calculateNextFrameUVRange(this.index);
            this.nextTime = Util.m_137574_() + (long)this.frameDuration.getOrDefault((this.index + 1) % (this.gridRows * this.gridColumns), this.duration).intValue();
        }
    }

    public UVRange getCurrentFrame() {
        return this.currentFrame;
    }

    private UVRange calculateNextFrameUVRange(int nextFrameIndex) {
        float frameWidth = 1.0f / (float)this.gridColumns;
        float frameHeight = 1.0f / (float)this.gridRows;
        float minU = (float)(nextFrameIndex / this.gridRows) * frameWidth;
        float maxU = minU + frameWidth;
        float minV = (float)(nextFrameIndex % this.gridRows) * frameHeight;
        float maxV = minV + frameHeight;
        return new UVRange(minU, minV, maxU, maxV);
    }
}

