/*
 * Decompiled with CFR 0.152.
 */
package com.foopy.forgeskyboxes.util;

import com.foopy.forgeskyboxes.FabricSkyBoxesClient;
import com.foopy.forgeskyboxes.api.skyboxes.FSBSkybox;
import com.foopy.forgeskyboxes.api.skyboxes.Skybox;
import com.foopy.forgeskyboxes.util.object.FogRGBA;
import com.foopy.forgeskyboxes.util.object.MinMaxEntry;
import com.foopy.forgeskyboxes.util.object.RGBA;
import com.foopy.forgeskyboxes.util.object.UVRange;
import com.google.common.collect.Range;
import com.mojang.serialization.Codec;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;

public class Utils {
    public static UVRange mapUVRanges(UVRange input, UVRange output, UVRange inputIntersection) {
        float u1 = (inputIntersection.getMinU() - input.getMinU()) / (input.getMaxU() - input.getMinU()) * (output.getMaxU() - output.getMinU()) + output.getMinU();
        float u2 = (inputIntersection.getMaxU() - input.getMinU()) / (input.getMaxU() - input.getMinU()) * (output.getMaxU() - output.getMinU()) + output.getMinU();
        float v1 = (inputIntersection.getMinV() - input.getMinV()) / (input.getMaxV() - input.getMinV()) * (output.getMaxV() - output.getMinV()) + output.getMinV();
        float v2 = (inputIntersection.getMaxV() - input.getMinV()) / (input.getMaxV() - input.getMinV()) * (output.getMaxV() - output.getMinV()) + output.getMinV();
        return new UVRange(u1, v1, u2, v2);
    }

    public static UVRange findUVIntersection(UVRange first, UVRange second) {
        float intersectionMinU = Math.max(first.getMinU(), second.getMinU());
        float intersectionMaxU = Math.min(first.getMaxU(), second.getMaxU());
        float intersectionMinV = Math.max(first.getMinV(), second.getMinV());
        float intersectionMaxV = Math.min(first.getMaxV(), second.getMaxV());
        if (intersectionMaxU >= intersectionMinU && intersectionMaxV >= intersectionMinV) {
            return new UVRange(intersectionMinU, intersectionMinV, intersectionMaxU, intersectionMaxV);
        }
        return null;
    }

    public static boolean checkRanges(double value, List<MinMaxEntry> minMaxEntries) {
        return minMaxEntries.isEmpty() || minMaxEntries.stream().anyMatch(minMaxEntry -> Range.closed((Comparable)Float.valueOf(minMaxEntry.getMin()), (Comparable)Float.valueOf(minMaxEntry.getMax())).contains((Comparable)Float.valueOf((float)value)));
    }

    public static <T> T warnIfDifferent(T initialValue, T finalValue, String message) {
        if (!initialValue.equals(finalValue) && FabricSkyBoxesClient.config().generalSettings.debugMode) {
            FabricSkyBoxesClient.getLogger().warn(message);
        }
        return finalValue;
    }

    public static int normalizeTickTime(long tickTime) {
        long result = tickTime % 24000L;
        return (int)(result >= 0L ? result : result + 24000L);
    }

    public static double calculateRotation(double rotationSpeed, int timeShift, boolean isSkyboxRotation, ClientLevel world) {
        if (rotationSpeed != 0.0) {
            long timeOfDay = world.m_46468_() + (long)timeShift;
            double rotationFraction = (double)timeOfDay / (24000.0 / rotationSpeed);
            double skyAngle = Mth.m_14109_((double)rotationFraction, (double)1.0);
            if (isSkyboxRotation) {
                return 360.0 * skyAngle;
            }
            return 360.0 * (double)world.m_6042_().m_63904_((long)(24000.0 * skyAngle));
        }
        return 0.0;
    }

    public static boolean isInTimeInterval(int currentTime, int startTime, int endTime) {
        if (currentTime < 0 || currentTime >= 24000) {
            throw new RuntimeException("Invalid current time, value must be between 0-23999: " + currentTime);
        }
        if (startTime <= endTime) {
            return currentTime >= startTime && currentTime <= endTime;
        }
        return currentTime >= startTime || currentTime <= endTime;
    }

    public static float calculateFadeAlphaValue(float maxAlpha, float minAlpha, int currentTime, int startFadeIn, int endFadeIn, int startFadeOut, int endFadeOut) {
        if (Utils.isInTimeInterval(currentTime, endFadeIn, startFadeOut)) {
            return maxAlpha;
        }
        if (Utils.isInTimeInterval(currentTime, startFadeIn, endFadeIn)) {
            int fadeInDuration = Utils.calculateCyclicTimeDistance(startFadeIn, endFadeIn);
            int timePassedSinceFadeInStart = Utils.calculateCyclicTimeDistance(startFadeIn, currentTime);
            return minAlpha + (float)timePassedSinceFadeInStart / (float)fadeInDuration * (maxAlpha - minAlpha);
        }
        if (Utils.isInTimeInterval(currentTime, startFadeOut, endFadeOut)) {
            int fadeOutDuration = Utils.calculateCyclicTimeDistance(startFadeOut, endFadeOut);
            int timePassedSinceFadeOutStart = Utils.calculateCyclicTimeDistance(startFadeOut, currentTime);
            return maxAlpha + (float)timePassedSinceFadeOutStart / (float)fadeOutDuration * (minAlpha - maxAlpha);
        }
        return minAlpha;
    }

    public static int calculateCyclicTimeDistance(int startTime, int endTime) {
        return (endTime - startTime + 24000) % 24000;
    }

    public static FogRGBA alphaBlendFogColors(List<Skybox> skyboxList, RGBA initialFogColor) {
        List<FogRGBA> activeColors = skyboxList.stream().filter(Skybox::isActive).filter(FSBSkybox.class::isInstance).map(FSBSkybox.class::cast).filter(fsbSkybox -> fsbSkybox.getProperties().isChangeFog()).map(fsbSkybox -> new FogRGBA(fsbSkybox.getProperties().getFogColors().getRed(), fsbSkybox.getProperties().getFogColors().getGreen(), fsbSkybox.getProperties().getFogColors().getBlue(), fsbSkybox.getAlpha() / fsbSkybox.getProperties().getMaxAlpha(), fsbSkybox.getProperties().getFogColors().getAlpha())).toList();
        if (activeColors.isEmpty()) {
            return null;
        }
        FogRGBA destination = new FogRGBA(initialFogColor);
        for (FogRGBA source : activeColors) {
            float sourceAlphaInv = 1.0f - source.getAlpha();
            float red = source.getRed() * source.getAlpha() + destination.getRed() * sourceAlphaInv;
            float green = source.getGreen() * source.getAlpha() + destination.getGreen() * sourceAlphaInv;
            float blue = source.getBlue() * source.getAlpha() + destination.getBlue() * sourceAlphaInv;
            float alpha = source.getAlpha() * source.getAlpha() + destination.getAlpha() * sourceAlphaInv;
            float density = source.getDensity() * source.getAlpha() + destination.getDensity() * sourceAlphaInv;
            destination = new FogRGBA(red, green, blue, alpha, density);
        }
        return destination;
    }

    public static RGBA weightedAdditiveBlendFogColors(List<Skybox> skyboxList, RGBA initialFogColor) {
        float[] colorSum = new float[4];
        List<RGBA> activeColors = skyboxList.stream().filter(Skybox::isActive).filter(FSBSkybox.class::isInstance).map(FSBSkybox.class::cast).filter(fsbSkybox -> fsbSkybox.getProperties().isChangeFog()).map(fsbSkybox -> new RGBA(fsbSkybox.getProperties().getFogColors().getRed(), fsbSkybox.getProperties().getFogColors().getGreen(), fsbSkybox.getProperties().getFogColors().getBlue(), fsbSkybox.getAlpha() / fsbSkybox.getProperties().getMaxAlpha())).toList();
        if (activeColors.size() == 0) {
            return null;
        }
        for (RGBA rgba : activeColors) {
            colorSum[0] = colorSum[0] + rgba.getRed() * rgba.getAlpha();
            colorSum[1] = colorSum[1] + rgba.getGreen() * rgba.getAlpha();
            colorSum[2] = colorSum[2] + rgba.getBlue() * rgba.getAlpha();
            colorSum[3] = colorSum[3] + rgba.getAlpha();
        }
        float finalAlpha = colorSum[3];
        RGBA activeColorsMixed = new RGBA(colorSum[0] / finalAlpha, colorSum[1] / finalAlpha, colorSum[2] / finalAlpha);
        Optional<RGBA> activeColorsHighestAlpha = activeColors.stream().max(Comparator.comparingDouble(RGBA::getAlpha));
        float activeColorsMaxAlpha = activeColorsHighestAlpha.get().getAlpha();
        float diffMul = 1.0f - activeColorsMaxAlpha;
        RGBA originalFogColorModified = new RGBA(initialFogColor.getRed() * diffMul, initialFogColor.getGreen() * diffMul, initialFogColor.getBlue() * diffMul);
        RGBA activeColorsMixedFinal = new RGBA(activeColorsMixed.getRed() * activeColorsMaxAlpha, activeColorsMixed.getGreen() * activeColorsMaxAlpha, activeColorsMixed.getBlue() * activeColorsMaxAlpha);
        return new RGBA(originalFogColorModified.getRed() + activeColorsMixedFinal.getRed(), originalFogColorModified.getGreen() + activeColorsMixedFinal.getGreen(), originalFogColorModified.getBlue() + activeColorsMixedFinal.getBlue());
    }

    public static float calculateConditionAlphaValue(float maxAlpha, float minAlpha, float lastAlpha, int duration, boolean in) {
        if (duration == 0) {
            return lastAlpha;
        }
        if (in && maxAlpha == lastAlpha) {
            return maxAlpha;
        }
        if (!in && lastAlpha == minAlpha) {
            return minAlpha;
        }
        float alphaChange = (maxAlpha - minAlpha) / (float)duration;
        float result = in ? lastAlpha + alphaChange : lastAlpha - alphaChange;
        return Mth.m_14036_((float)result, (float)minAlpha, (float)maxAlpha);
    }

    public static Codec<Integer> getClampedInteger(int min, int max) {
        if (min > max) {
            throw new UnsupportedOperationException("Maximum value was lesser than than the minimum value");
        }
        return Codec.INT.xmap(f -> Mth.m_14045_((int)f, (int)min, (int)max), Function.identity());
    }

    public static Codec<Float> getClampedFloat(float min, float max) {
        if (min > max) {
            throw new UnsupportedOperationException("Maximum value was lesser than than the minimum value");
        }
        return Codec.FLOAT.xmap(f -> Float.valueOf(Mth.m_14036_((float)f.floatValue(), (float)min, (float)max)), Function.identity());
    }

    public static Codec<Double> getClampedDouble(double min, double max) {
        if (min > max) {
            throw new UnsupportedOperationException("Maximum value was lesser than than the minimum value");
        }
        return Codec.DOUBLE.xmap(f -> Mth.m_14008_((double)f, (double)min, (double)max), Function.identity());
    }
}

