/*
 * Decompiled with CFR 0.152.
 */
package com.foopy.forgeskyboxes.skyboxes.textured;

import com.foopy.forgeskyboxes.api.skyboxes.RotatableSkybox;
import com.foopy.forgeskyboxes.mixin.skybox.WorldRendererAccess;
import com.foopy.forgeskyboxes.skyboxes.AbstractSkybox;
import com.foopy.forgeskyboxes.util.Utils;
import com.foopy.forgeskyboxes.util.object.Blend;
import com.foopy.forgeskyboxes.util.object.Conditions;
import com.foopy.forgeskyboxes.util.object.Decorations;
import com.foopy.forgeskyboxes.util.object.Properties;
import com.foopy.forgeskyboxes.util.object.Rotation;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public abstract class TexturedSkybox
extends AbstractSkybox
implements RotatableSkybox {
    public Rotation rotation;
    public Blend blend;

    protected TexturedSkybox() {
    }

    protected TexturedSkybox(Properties properties, Conditions conditions, Decorations decorations, Blend blend) {
        super(properties, conditions, decorations);
        this.blend = blend;
        this.rotation = properties.getRotation();
    }

    @Override
    public final void render(WorldRendererAccess worldRendererAccess, PoseStack matrices, Matrix4f matrix4f, float tickDelta, Camera camera, boolean thickFog) {
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        this.blend.applyBlendFunc(this.alpha);
        ClientLevel world = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        Vector3f rotationStatic = this.rotation.getStatic();
        matrices.m_85836_();
        double timeRotationX = Utils.calculateRotation(this.rotation.getRotationSpeedX(), this.rotation.getTimeShift().x(), this.rotation.getSkyboxRotation(), world);
        double timeRotationY = Utils.calculateRotation(this.rotation.getRotationSpeedY(), this.rotation.getTimeShift().y(), this.rotation.getSkyboxRotation(), world);
        double timeRotationZ = Utils.calculateRotation(this.rotation.getRotationSpeedZ(), this.rotation.getTimeShift().z(), this.rotation.getSkyboxRotation(), world);
        this.applyTimeRotation(matrices, (float)timeRotationX, (float)timeRotationY, (float)timeRotationZ);
        matrices.m_252781_(Axis.f_252529_.m_252977_(rotationStatic.x()));
        matrices.m_252781_(Axis.f_252436_.m_252977_(rotationStatic.y()));
        matrices.m_252781_(Axis.f_252403_.m_252977_(rotationStatic.z()));
        this.renderSkybox(worldRendererAccess, matrices, tickDelta, camera, thickFog);
        matrices.m_85849_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        this.renderDecorations(worldRendererAccess, matrices, matrix4f, tickDelta, bufferBuilder, this.alpha);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public abstract void renderSkybox(WorldRendererAccess var1, PoseStack var2, float var3, Camera var4, boolean var5);

    private void applyTimeRotation(PoseStack matrices, float timeRotationX, float timeRotationY, float timeRotationZ) {
        Vector3f timeRotationAxis = this.rotation.getAxis();
        matrices.m_252781_(Axis.f_252529_.m_252977_(timeRotationAxis.x()));
        matrices.m_252781_(Axis.f_252436_.m_252977_(timeRotationAxis.y()));
        matrices.m_252781_(Axis.f_252403_.m_252977_(timeRotationAxis.z()));
        matrices.m_252781_(Axis.f_252529_.m_252977_(timeRotationX));
        matrices.m_252781_(Axis.f_252436_.m_252977_(timeRotationY));
        matrices.m_252781_(Axis.f_252403_.m_252977_(timeRotationZ));
        matrices.m_252781_(Axis.f_252393_.m_252977_(timeRotationAxis.z()));
        matrices.m_252781_(Axis.f_252392_.m_252977_(timeRotationAxis.y()));
        matrices.m_252781_(Axis.f_252495_.m_252977_(timeRotationAxis.x()));
    }

    public Blend getBlend() {
        return this.blend;
    }

    @Override
    public Rotation getRotation() {
        return this.rotation;
    }
}

