/*
 * Decompiled with CFR 0.152.
 */
package com.foopy.forgeskyboxes.skyboxes.textured;

import com.foopy.forgeskyboxes.mixin.skybox.WorldRendererAccess;
import com.foopy.forgeskyboxes.skyboxes.AbstractSkybox;
import com.foopy.forgeskyboxes.skyboxes.SkyboxType;
import com.foopy.forgeskyboxes.skyboxes.textured.TexturedSkybox;
import com.foopy.forgeskyboxes.util.Utils;
import com.foopy.forgeskyboxes.util.object.Animation;
import com.foopy.forgeskyboxes.util.object.Blend;
import com.foopy.forgeskyboxes.util.object.Conditions;
import com.foopy.forgeskyboxes.util.object.Decorations;
import com.foopy.forgeskyboxes.util.object.Properties;
import com.foopy.forgeskyboxes.util.object.UVRange;
import com.foopy.forgeskyboxes.util.object.UVRanges;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class MultiTextureSkybox
extends TexturedSkybox {
    public static Codec<MultiTextureSkybox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Properties.CODEC.fieldOf("properties").forGetter(AbstractSkybox::getProperties), (App)Conditions.CODEC.optionalFieldOf("conditions", (Object)Conditions.DEFAULT).forGetter(AbstractSkybox::getConditions), (App)Decorations.CODEC.optionalFieldOf("decorations", (Object)Decorations.DEFAULT).forGetter(AbstractSkybox::getDecorations), (App)Blend.CODEC.optionalFieldOf("blend", (Object)Blend.DEFAULT).forGetter(TexturedSkybox::getBlend), (App)Animation.CODEC.listOf().optionalFieldOf("animations", new ArrayList()).forGetter(MultiTextureSkybox::getAnimations)).apply((Applicative)instance, MultiTextureSkybox::new));
    protected final List<Animation> animations;
    private final UVRanges uvRanges;
    private final float quadSize = 100.0f;
    private final UVRange quad = new UVRange(-this.quadSize, -this.quadSize, this.quadSize, this.quadSize);

    public MultiTextureSkybox(Properties properties, Conditions conditions, Decorations decorations, Blend blend, List<Animation> animations) {
        super(properties, conditions, decorations, blend);
        this.animations = animations;
        this.uvRanges = (UVRanges)Util.m_137537_(() -> new UVRanges(new UVRange(0.33333334f, 0.5f, 0.6666667f, 1.0f), new UVRange(0.6666667f, 0.0f, 1.0f, 0.5f), new UVRange(0.6666667f, 0.5f, 1.0f, 1.0f), new UVRange(0.0f, 0.5f, 0.33333334f, 1.0f), new UVRange(0.33333334f, 0.0f, 0.6666667f, 0.5f), new UVRange(0.0f, 0.0f, 0.33333334f, 0.5f)));
    }

    @Override
    public SkyboxType<? extends AbstractSkybox> getType() {
        return (SkyboxType)SkyboxType.MONO_COLOR_SKYBOX.get();
    }

    @Override
    public void renderSkybox(WorldRendererAccess worldRendererAccess, PoseStack matrices, float tickDelta, Camera camera, boolean thickFog) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        for (int i = 0; i < 6; ++i) {
            UVRange faceUVRange = this.uvRanges.byId(i);
            matrices.m_85836_();
            if (i == 1) {
                matrices.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            } else if (i == 2) {
                matrices.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                matrices.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            } else if (i == 3) {
                matrices.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            } else if (i == 4) {
                matrices.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                matrices.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            } else if (i == 5) {
                matrices.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
                matrices.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            }
            Matrix4f matrix4f = matrices.m_85850_().m_252922_();
            for (Animation animation : this.animations) {
                animation.tick();
                UVRange intersect = Utils.findUVIntersection(faceUVRange, animation.getUvRanges());
                if (intersect == null || animation.getCurrentFrame() == null) continue;
                UVRange intersectionOnCurrentTexture = Utils.mapUVRanges(faceUVRange, this.quad, intersect);
                UVRange intersectionOnCurrentFrame = Utils.mapUVRanges(animation.getUvRanges(), animation.getCurrentFrame(), intersect);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)animation.getTexture().getTextureId());
                bufferBuilder.m_252986_(matrix4f, intersectionOnCurrentTexture.getMinU(), -this.quadSize, intersectionOnCurrentTexture.getMinV()).m_7421_(intersectionOnCurrentFrame.getMinU(), intersectionOnCurrentFrame.getMinV()).m_5752_();
                bufferBuilder.m_252986_(matrix4f, intersectionOnCurrentTexture.getMinU(), -this.quadSize, intersectionOnCurrentTexture.getMaxV()).m_7421_(intersectionOnCurrentFrame.getMinU(), intersectionOnCurrentFrame.getMaxV()).m_5752_();
                bufferBuilder.m_252986_(matrix4f, intersectionOnCurrentTexture.getMaxU(), -this.quadSize, intersectionOnCurrentTexture.getMaxV()).m_7421_(intersectionOnCurrentFrame.getMaxU(), intersectionOnCurrentFrame.getMaxV()).m_5752_();
                bufferBuilder.m_252986_(matrix4f, intersectionOnCurrentTexture.getMaxU(), -this.quadSize, intersectionOnCurrentTexture.getMinV()).m_7421_(intersectionOnCurrentFrame.getMaxU(), intersectionOnCurrentFrame.getMinV()).m_5752_();
            }
            matrices.m_85849_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    public List<Animation> getAnimations() {
        return this.animations;
    }
}

