/*
 * Decompiled with CFR 0.152.
 */
package com.foopy.forgeskyboxes.skyboxes.textured;

import com.foopy.forgeskyboxes.mixin.skybox.WorldRendererAccess;
import com.foopy.forgeskyboxes.skyboxes.AbstractSkybox;
import com.foopy.forgeskyboxes.skyboxes.SkyboxType;
import com.foopy.forgeskyboxes.skyboxes.textured.SquareTexturedSkybox;
import com.foopy.forgeskyboxes.skyboxes.textured.TexturedSkybox;
import com.foopy.forgeskyboxes.util.object.Blend;
import com.foopy.forgeskyboxes.util.object.Conditions;
import com.foopy.forgeskyboxes.util.object.Decorations;
import com.foopy.forgeskyboxes.util.object.Properties;
import com.foopy.forgeskyboxes.util.object.Textures;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.client.Camera;

public class AnimatedSquareTexturedSkybox
extends SquareTexturedSkybox {
    public static final Codec<AnimatedSquareTexturedSkybox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Properties.CODEC.fieldOf("properties").forGetter(AbstractSkybox::getProperties), (App)Conditions.CODEC.optionalFieldOf("conditions", (Object)Conditions.DEFAULT).forGetter(AbstractSkybox::getConditions), (App)Decorations.CODEC.optionalFieldOf("decorations", (Object)Decorations.DEFAULT).forGetter(AbstractSkybox::getDecorations), (App)Blend.CODEC.optionalFieldOf("blend", (Object)Blend.DEFAULT).forGetter(TexturedSkybox::getBlend), (App)Textures.CODEC.listOf().fieldOf("animationTextures").forGetter(AnimatedSquareTexturedSkybox::getAnimationTextures), (App)Codec.FLOAT.fieldOf("fps").forGetter(AnimatedSquareTexturedSkybox::getFps)).apply((Applicative)instance, AnimatedSquareTexturedSkybox::new));
    private final List<Textures> animationTextures;
    private final float fps;
    private final long frameTimeMillis;
    private int count = 0;
    private long lastTime = 0L;

    public AnimatedSquareTexturedSkybox(Properties properties, Conditions conditions, Decorations decorations, Blend blend, List<Textures> animationTextures, float fps) {
        super(properties, conditions, decorations, blend, null);
        this.animationTextures = animationTextures;
        this.fps = fps;
        this.frameTimeMillis = fps > 0.0f && fps <= 360.0f ? (long)(1000.0f / fps) : 16L;
    }

    @Override
    public SkyboxType<? extends AbstractSkybox> getType() {
        return (SkyboxType)SkyboxType.ANIMATED_SQUARE_TEXTURED_SKYBOX.get();
    }

    @Override
    public void renderSkybox(WorldRendererAccess worldRendererAccess, PoseStack matrices, float tickDelta, Camera camera, boolean thickFog) {
        if (this.lastTime == 0L) {
            this.lastTime = System.currentTimeMillis();
        }
        this.textures = this.getAnimationTextures().get(this.count);
        super.renderSkybox(worldRendererAccess, matrices, tickDelta, camera, thickFog);
        if (System.currentTimeMillis() >= this.lastTime + this.frameTimeMillis) {
            if (this.count < this.getAnimationTextures().size()) {
                this.count = this.count + 1 == this.getAnimationTextures().size() ? 0 : ++this.count;
            }
            this.lastTime = System.currentTimeMillis();
        }
    }

    public List<Textures> getAnimationTextures() {
        return this.animationTextures;
    }

    public float getFps() {
        return this.fps;
    }
}

