/*
 * Decompiled with CFR 0.152.
 */
package com.foopy.forgeskyboxes.skyboxes;

import com.foopy.forgeskyboxes.skyboxes.AbstractSkybox;
import com.foopy.forgeskyboxes.skyboxes.EndSkybox;
import com.foopy.forgeskyboxes.skyboxes.LegacyDeserializer;
import com.foopy.forgeskyboxes.skyboxes.MonoColorSkybox;
import com.foopy.forgeskyboxes.skyboxes.OverworldSkybox;
import com.foopy.forgeskyboxes.skyboxes.textured.AnimatedSquareTexturedSkybox;
import com.foopy.forgeskyboxes.skyboxes.textured.MultiTextureSkybox;
import com.foopy.forgeskyboxes.skyboxes.textured.SingleSpriteAnimatedSquareTexturedSkybox;
import com.foopy.forgeskyboxes.skyboxes.textured.SingleSpriteSquareTexturedSkybox;
import com.foopy.forgeskyboxes.skyboxes.textured.SquareTexturedSkybox;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkyboxType<T extends AbstractSkybox> {
    public static final DeferredRegister<SkyboxType<? extends AbstractSkybox>> SKYBOX_TYPE = DeferredRegister.create((ResourceKey)ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("forgeskyboxes", "skybox_type")), (String)"forgeskyboxes");
    public static final Supplier<IForgeRegistry<SkyboxType<? extends AbstractSkybox>>> REGISTRY = SKYBOX_TYPE.makeRegistry(RegistryBuilder::new);
    public static final RegistryObject<SkyboxType<MonoColorSkybox>> MONO_COLOR_SKYBOX = SKYBOX_TYPE.register("monocolor", () -> Builder.create(MonoColorSkybox.class, "monocolor").legacySupported().deserializer((LegacyDeserializer)LegacyDeserializer.MONO_COLOR_SKYBOX_DESERIALIZER.get()).factory(MonoColorSkybox::new).add(2, MonoColorSkybox.CODEC).build());
    public static final RegistryObject<SkyboxType<OverworldSkybox>> OVERWORLD_SKYBOX = SKYBOX_TYPE.register("overworld", () -> Builder.create(OverworldSkybox.class, "overworld").add(2, OverworldSkybox.CODEC).build());
    public static final RegistryObject<SkyboxType<EndSkybox>> END_SKYBOX = SKYBOX_TYPE.register("end", () -> Builder.create(EndSkybox.class, "end").add(2, EndSkybox.CODEC).build());
    public static final RegistryObject<SkyboxType<SquareTexturedSkybox>> SQUARE_TEXTURED_SKYBOX = SKYBOX_TYPE.register("square_textured", () -> Builder.create(SquareTexturedSkybox.class, "square-textured").deserializer((LegacyDeserializer)LegacyDeserializer.SQUARE_TEXTURED_SKYBOX_DESERIALIZER.get()).legacySupported().factory(SquareTexturedSkybox::new).add(2, SquareTexturedSkybox.CODEC).build());
    public static final RegistryObject<SkyboxType<SingleSpriteSquareTexturedSkybox>> SINGLE_SPRITE_SQUARE_TEXTURED_SKYBOX = SKYBOX_TYPE.register("single_sprite_square_textured", () -> Builder.create(SingleSpriteSquareTexturedSkybox.class, "single-sprite-square-textured").add(2, SingleSpriteSquareTexturedSkybox.CODEC).build());
    public static final RegistryObject<SkyboxType<AnimatedSquareTexturedSkybox>> ANIMATED_SQUARE_TEXTURED_SKYBOX = SKYBOX_TYPE.register("animated_square_textured", () -> Builder.create(AnimatedSquareTexturedSkybox.class, "animated-square-textured").add(2, AnimatedSquareTexturedSkybox.CODEC).build());
    public static final RegistryObject<SkyboxType<SingleSpriteAnimatedSquareTexturedSkybox>> SINGLE_SPRITE_ANIMATED_SQUARE_TEXTURED_SKYBOX = SKYBOX_TYPE.register("single_sprite_animated_square_textured", () -> Builder.create(SingleSpriteAnimatedSquareTexturedSkybox.class, "single-sprite-animated-square-textured").add(2, SingleSpriteAnimatedSquareTexturedSkybox.CODEC).build());
    public static final RegistryObject<SkyboxType<MultiTextureSkybox>> MULTI_TEXTURE_SKYBOX = SKYBOX_TYPE.register("multi_texture", () -> Builder.create(MultiTextureSkybox.class, "multi-texture").add(2, MultiTextureSkybox.CODEC).build());
    public static final Codec<ResourceLocation> SKYBOX_ID_CODEC = Codec.STRING.xmap(s -> {
        if (!s.contains(":")) {
            return new ResourceLocation("forgeskyboxes", s.replace('-', '_'));
        }
        return new ResourceLocation(s.replace('-', '_'));
    }, id -> {
        if (id.m_135827_().equals("forgeskyboxes")) {
            return id.m_135815_().replace('_', '-');
        }
        return id.toString().replace('_', '-');
    });
    private final BiMap<Integer, Codec<T>> codecBiMap;
    private final boolean legacySupported;
    private final String name;
    @Nullable
    private final Supplier<T> factory;
    @Nullable
    private final LegacyDeserializer<T> deserializer;

    private SkyboxType(BiMap<Integer, Codec<T>> codecBiMap, boolean legacySupported, String name, @Nullable Supplier<T> factory, @Nullable LegacyDeserializer<T> deserializer) {
        this.codecBiMap = codecBiMap;
        this.legacySupported = legacySupported;
        this.name = name;
        this.factory = factory;
        this.deserializer = deserializer;
    }

    public static void initRegistry() {
        if (REGISTRY == null) {
            System.err.println("[FabricSkyboxes] Registry not loaded?");
        }
    }

    private static <T extends AbstractSkybox> SkyboxType<T> register(SkyboxType<T> type) {
        return (SkyboxType)SKYBOX_TYPE.register(type.name.replace('-', '_'), () -> type).get();
    }

    public String getName() {
        return this.name;
    }

    public boolean isLegacySupported() {
        return this.legacySupported;
    }

    @NotNull
    public T instantiate() {
        return (T)Objects.requireNonNull((AbstractSkybox)Objects.requireNonNull(this.factory, "Can't instantiate from a null factory").get());
    }

    @Nullable
    public LegacyDeserializer<T> getDeserializer() {
        return this.deserializer;
    }

    public ResourceLocation createId(String namespace) {
        return this.createIdFactory().apply(namespace);
    }

    public Function<String, ResourceLocation> createIdFactory() {
        return ns -> new ResourceLocation(ns, this.getName().replace('-', '_'));
    }

    public Codec<T> getCodec(int schemaVersion) {
        return Objects.requireNonNull((Codec)this.codecBiMap.get((Object)schemaVersion), String.format("Unsupported schema version '%d' for skybox type %s", schemaVersion, this.name));
    }

    public static class Builder<T extends AbstractSkybox> {
        private final ImmutableBiMap.Builder<Integer, Codec<T>> builder = ImmutableBiMap.builder();
        private String name;
        private boolean legacySupported = false;
        private Supplier<T> factory;
        private LegacyDeserializer<T> deserializer;

        private Builder() {
        }

        public static <S extends AbstractSkybox> Builder<S> create(Class<S> clazz, String name) {
            Builder builder = new Builder();
            builder.name = name;
            return builder;
        }

        public static <S extends AbstractSkybox> Builder<S> create(String name) {
            Builder builder = new Builder();
            builder.name = name;
            return builder;
        }

        protected Builder<T> legacySupported() {
            this.legacySupported = true;
            return this;
        }

        protected Builder<T> factory(Supplier<T> factory) {
            this.factory = factory;
            return this;
        }

        protected Builder<T> deserializer(LegacyDeserializer<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public Builder<T> add(int schemaVersion, Codec<T> codec) {
            Preconditions.checkArgument((schemaVersion >= 2 ? 1 : 0) != 0, (Object)"schema version was lesser than 2");
            Preconditions.checkNotNull(codec, (Object)"codec was null");
            this.builder.put((Object)schemaVersion, codec);
            return this;
        }

        public SkyboxType<T> build() {
            if (this.legacySupported) {
                Preconditions.checkNotNull(this.factory, (Object)"factory was null");
                Preconditions.checkNotNull(this.deserializer, (Object)"deserializer was null");
            }
            return new SkyboxType<T>(this.builder.build(), this.legacySupported, this.name, this.factory, this.deserializer);
        }
    }
}

